/* Functions to calculate the (auto|cross)correlograms */

#ifdef MNEMOSYNE
#include "mnemosyne.h"
#endif

#include <stdio.h>
#include <math.h>

#include "sahist.h"
#include "srl.h"
#include "correl.h"


SA_Histogram *SA_Correlate(
     SA_SpikeRasterList *srl1,
     SA_SpikeRasterList *srl2,
     int autocor_flag,		/* autocorrelation mode? */
     float tmin, float tmax,	/* window time in ms */
     int nbins)			/* number of bins */
{
  float binwidth;
  float *r1, *r2, dt;
  int i,  n1, n2, j1, j2, bnum;
  SA_Histogram *h;

  binwidth = (tmax - tmin) / (float)nbins;
  h = SA_NewSA_Histogram(nbins);

  for (i = 0; i < nbins; i++) {
    (h->x)[i] = tmin + (i * binwidth);
    (h->y)[i] = 0.0;
  }

  for (i = 0; i < srl1->nrasters && i < srl2->nrasters; i++) {
    r1 = srl1->sr[i]->tm;
    n1 = srl1->sr[i]->nspikes;
    r2 = srl2->sr[i]->tm;
    n2 = srl2->sr[i]->nspikes;
    for (j1 = 0; j1 < n1; j1++) {
      for (j2 = 0; j2 < n2; j2++) {
	if (!autocor_flag || j1 != j2) {
	  dt = r1[j1] - r2[j2];
	  dt = (dt - tmin) / binwidth;
	  if (dt >= 0.0)
	    bnum = (int)(dt + 0.5);
	  else
	    bnum = (int)(dt - 0.5);
	  if (bnum < nbins && bnum >= 0)
	    (h->y)[bnum] += 1.0;
	}
      }
    }
  }
  return(h);
}
