#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include "Plotter.h"
#include "Plot.h"
#include "QuadPlot.h"
#include "QuadLinePlot.h"
#include "QuadBarPlot.h"
#include "QuadAxis.h"
#include "TextPlot.h"

#include "stdio.h"
#include "stdlib.h"
#include "assert.h"
#include "values.h"
#include "limits.h"

static char *get_var(char*, char*);
static int get_var_int(char*, char*);
static int skipto(FILE*, char*);
static int read_data(FILE*, char**, void**, void**, void**, int*);

static char *get_var(char *params, char *var)
{
  char *ptr,*ptr2,tmp[64];
  static char ret[64];
  int n;

  char *foo;

	sprintf(tmp,"\n%s=",var);

  ptr = strstr(params,tmp);
  if(ptr==NULL)
    return(NULL);
  ptr += strlen(tmp);
  ptr2 = strchr(ptr,'\n');
  assert((n=(int)(ptr2-ptr)/sizeof(char))<64);
  strncpy(ret,ptr,n);
  ret[n]='\0';

  assert((foo=(char*)malloc(strlen(ret)*sizeof(char)))!=NULL);
  strcpy(foo,ret);
  return(foo);
}

static int get_var_int(char *params, char *var)
{
  int ret;
  char *tmp;

  if((tmp = get_var(params,var))!=NULL)
    sscanf(tmp,"%d",&ret);
  else
    ret = INT_MAX;

  return(ret);
}

static double get_var_double(char *params, char *var)
{
  double ret;
  char *tmp;

  if((tmp = get_var(params,var))!=NULL)
    sscanf(tmp,"%lf",&ret);
  else
    ret = MAXDOUBLE;

  return(ret);
}

static int skipto(FILE *fp, char *str)
{
  char ret[128];

  fgets(ret,sizeof(ret),fp);
  while(strcmp(ret,str) && !feof(fp))
    fgets(ret,sizeof(ret),fp);

  return(!feof(fp) ? 1 : 0);
}

static int read_data(FILE *fp, char **params, void **px, void **py, void **pz,
			int *pn)
{
  char ln[128];
  int size,count;
  int ncols;
  char *ret,*argt,arg[20],stride;
  void *a,*b,*c;

  count=0;
  size=1000;
  assert(((*params)=(char*)malloc(size*sizeof(char)))!=NULL);
	strcpy(*params,"\n");

  if(!skipto(fp,"BEGIN_PARAMS\n")) return(0);
  fgets(ln,sizeof(ln),fp);
  while(strcmp(ln,"END_PARAMS\n")) {
    strcat(*params,ln);  count += strlen(ln);
    if((size-count)<50) {
      size+=1000;
      assert(((*params)=(char*)realloc(*params,size*sizeof(char)))!=NULL); }
    fgets(ln,sizeof(ln),fp); }
  assert(((*params)=(char*)realloc(*params,
        strlen(*params)*sizeof(char)))!=NULL);
  
  ret = get_var(*params,"DataType");
  if(!strcmp(ret,"AtFloat")) {
    argt = "%f";
    stride = sizeof(float); }
  else if(!strcmp(ret,"AtDouble")) {
    argt = "%lf";
    stride = sizeof(double); }
  else if(!strcmp(ret,"AtShort")) {
    argt = "%hd";
    stride = sizeof(short); }
  else if(!strcmp(ret,"AtInt")) {
    argt = "%d";
    stride = sizeof(int); }

  /* X==1 means there's a column of X data.  likewise for Z==1.
   * Z==2 means there's a column, but don't plot it.  */
     
  ncols=1;
  strcpy(arg,argt);
  if(get_var_int(*params,"X")==1) {
    ncols++;
    strcat(arg," ");
    strcat(arg,argt); }
  if(get_var_int(*params,"Z")>0) {
    ncols++;
    strcat(arg," ");
    strcat(arg,argt); }
    
  count=0;
  size=20;
  assert(((a)=(void*)malloc(size*stride))!=NULL);
  if(ncols>1) assert(((b)=(void*)malloc(size*stride))!=NULL);
  if(ncols>2) assert(((c)=(void*)malloc(size*stride))!=NULL);

  if(!skipto(fp,"BEGIN_DATA\n")) return(0);
  count=0;
  fgets(ln,sizeof(ln),fp);
  while(strcmp(ln,"END_DATA\n")) {
    switch(ncols) {
      case(1):
        sscanf(ln,arg,a+count*stride);
        break;
      case(2):
        sscanf(ln,arg,a+count*stride,b+count*stride);
        break;
      case(3):
        sscanf(ln,arg,a+count*stride,b+count*stride,c+count*stride);
        break; }
    count++;
    if((size-count)<2) {
      size+=20;
      assert(((a)=(void*)realloc(a,size*stride))!=NULL);
      if(ncols>1) assert(((b)=(void*)realloc(b,size*stride))!=NULL);
      if(ncols>2) assert(((c)=(void*)realloc(c,size*stride))!=NULL); }
    fgets(ln,sizeof(ln),fp); }

  if(get_var_int(*params,"X")==1) {
    (*px) = a;
    (*py) = b;
    (*pz) = (get_var_int(*params,"Z")==1) ? c : NULL; }
  else {
    (*px) = NULL; 
    (*py) = a;
    (*pz) = (get_var_int(*params,"NoZ")==1) ? b : NULL; }
	(*pn) = count;

  return(1);
}

typedef struct {
  char *string;
  WidgetClass val;
} AtClassRec;

static AtClassRec class_table[] = {
     { "LINE",  NULL },  /* set in main() */
     { "BAR",   NULL },
     { NULL,    NULL } };

static WidgetClass parse_class(char *params)
{
  char *tmp;
  int i;

  tmp=get_var(params,"Class");

  i=0;
  while(class_table[i].string!=NULL) {
    if(!strcasecmp(class_table[i].string,tmp))
      return(class_table[i].val);
    i++; }

  return(NULL);
}

typedef struct {
	String arg1;
	String arg2;
} AtParmsTable;

static AtParmsTable line_table[] = {
    { XtVaTypedArg, XtNplotType },
    { XtVaTypedArg, XtNplotLine },
    { XtVaTypedArg, XtNplotMark },
    { XtVaTypedArg, XtNplotColor },
    { XtVaTypedArg, XtNmarkFill },
    { XtVaTypedArg, XtNerrBarSide },
    { XtNerrBarSize, NULL },
    { XtNmarkGuage, NULL },
		{ NULL },
};

static AtParmsTable bar_table[] = {
   	{ XtVaTypedArg, XtNerrBarSide },
   	{ XtVaTypedArg, XtNdoOutline },
   	{ XtVaTypedArg, XtNdoFill },
   	{ XtVaTypedArg, XtNoutlineColor },
   	{ XtVaTypedArg, XtNfillColor },
    { XtVaTypedArg, XtNbarOrientation },
    { XtNerrBarSize, NULL },
    { XtNbarOffset, NULL },
    { XtNbarWidth,  NULL },
		{ NULL },
};

static void set_values(Widget line, AtParmsTable *table, char *params)
{
	double tmpd;
	char *tmps;
	int i;

	i=0;
	while(table[i].arg1 != NULL) {
		if(!strcmp(table[i].arg1,XtVaTypedArg)) {
      if((tmps = get_var(params, table[i].arg2))!=NULL)
      	XtVaSetValues(line, XtVaTypedArg, table[i].arg2, XtRString,
	  					tmps, 1+strlen(tmps), NULL); }
		else {
      if((tmpd = get_var_double(params, table[i].arg1))!=MAXDOUBLE)
        XtVaSetValues(line, table[i].arg1, &tmpd, NULL); }
		i++; }
}

int main(int argc, char **argv)
{
  XtAppContext TopLevelContext;
  Widget TopLevel, graph, xaxis, yaxis, line;
  char *params;
  void *px, *py, *pz;
	int pn;
  char *tmps;
	int ps_flag, ps_scale=1;

  class_table[0].val = atQuadLinePlotWidgetClass;
  class_table[1].val = atQuadBarPlotWidgetClass;

  TopLevel = XtVaAppInitialize(&TopLevelContext,
          "QuadTest", NULL, 0, &argc, argv, NULL, NULL);

  ps_flag = ((argc>1) && !strncmp(argv[1],"-ps",3)) ? 1 : 0;

	if(ps_flag)
    graph = XtVaCreateManagedWidget("graph", atPlotterWidgetClass,
      TopLevel, XtNwidth, 400*ps_scale, XtNheight, 350*ps_scale,
      XtNshowLegend, False, NULL);
	else
    graph = XtVaCreateManagedWidget("graph", atPlotterWidgetClass,
      TopLevel, XtNwidth, 400, XtNheight, 350,
      XtNshowLegend, False, NULL);
 
  xaxis = XtVaCreateWidget("xaxis", atQuadAxisWidgetClass, graph,
    XtNvertical, False, XtNlabel, "undef", NULL);
  yaxis = XtVaCreateWidget("yaxis", atQuadAxisWidgetClass, graph,
    XtNvertical, True, XtNlabel, "undef", NULL);
  XtVaSetValues(graph, XtNxAxis, xaxis, XtNyAxis, yaxis, NULL);

	while(read_data(stdin, &params, &px, &py, &pz, &pn)) {

	  line = XtVaCreateWidget("line", parse_class(params), graph, NULL);

    if((tmps = get_var(params, "RoundEndpoints"))!=NULL) {
     	XtVaSetValues(xaxis, XtVaTypedArg, XtNroundEndpoints, XtRString,
  					tmps, 1+strlen(tmps), NULL);
     	XtVaSetValues(yaxis, XtVaTypedArg, XtNroundEndpoints, XtRString,
  					tmps, 1+strlen(tmps), NULL); }
    if((tmps = get_var(params, "Grid"))!=NULL) {
     	XtVaSetValues(xaxis, XtVaTypedArg, XtNdrawGrid, XtRString,
  					tmps, 1+strlen(tmps), NULL);
     	XtVaSetValues(yaxis, XtVaTypedArg, XtNdrawGrid, XtRString,
  					tmps, 1+strlen(tmps), NULL); }
    if((tmps = get_var(params, "Title"))!=NULL)
     	XtVaSetValues(graph, XtVaTypedArg, XtNtitle, XtRString,
  					tmps, 1+strlen(tmps), NULL);
    if((tmps = get_var(params, "XLabel"))!=NULL)
     	XtVaSetValues(xaxis, XtVaTypedArg, XtNlabel, XtRString,
  					tmps, 1+strlen(tmps), NULL);
    if((tmps = get_var(params, "YLabel"))!=NULL)
     	XtVaSetValues(yaxis, XtVaTypedArg, XtNlabel, XtRString,
  					tmps, 1+strlen(tmps), NULL);

    if(parse_class(params)==atQuadLinePlotWidgetClass)
			set_values(line, line_table, params);
    else if(parse_class(params)==atQuadBarPlotWidgetClass)
			set_values(line, bar_table, params);

    AtQuadPlotAttachData(line, px, AtFloat, sizeof(float),
        py, AtFloat, sizeof(float), pz, AtFloat, sizeof(float),
        NULL, AtFloat, sizeof(float), 1, pn);

    free(params); }

  XtRealizeWidget(TopLevel);

  if(ps_flag)
		AtPlotterGeneratePostscript("-","w",graph,
					0.8,argv[1][3] == 'c' ? 1 : 0);
	else
    XtAppMainLoop(TopLevelContext);

	return(1);
}
