/*
 *      TextPlotP.h
 *
 *      The AthenaTools Plotter Widget Set - Version 6.0
 *
 *      klin, Tue Jul  7 13:59:47 1992
 *      klin, Sat Aug 15 10:31:50 1992, patchlevel 4
 *                                      Changed <At/..> to <X11/At/..>.
 *      klin, Wed Sep  8 09:43:34 1993, patchlevel 8
 *                                      XtNverticalJustify added.
 *                                      Some minor changes.
 *
 *      SCCSid[] = "@(#) Plotter V6.0  93/09/08  TextPlotP.h"
 */

#ifndef _At_TextPlotP_h
#define _At_TextPlotP_h

#include "At.h"
#include "PlotP.h"
#include "TextPlot.h"
#include "FontFamily.h"
#include "Text.h"

typedef struct _AtTextPlotClassPart {
     int higgledy_piggledy;
} AtTextPlotClassPart;

typedef struct _AtTextPlotClassRec {
     ObjectClassPart     object_class;
     AtPlotClassPart     plot_class;
     AtTextPlotClassPart textplot_class;
} AtTextPlotClassRec;

extern AtTextPlotClassRec atTextPlotClassRec;

typedef struct _AtTextPlotPart {
     /* Resources */
     String         label;
     String         font_family;
     int            font_size;
     int            font_style;
     int            horizontal_justify;
     int            vertical_justify;
     int            x;
     int            y;
     Boolean        floating_position;
     double         floating_x;
     double         floating_y;

     /* Private state */
     AtText         *label_text;
     AtFontFamily   *ff;
     /* Percentage of x & y, set at create time */
     float          xpercent;
     float          ypercent;
     /* There it actually is after justifying it */
     int            xpos, ypos;
} AtTextPlotPart;

typedef struct _AtTextPlotRec {
     ObjectPart     object;
     AtPlotPart     plot;
     AtTextPlotPart textplot;
} AtTextPlotRec;

#endif /* _At_TextPlotP_h */
