/*
 *      Text.h
 *
 *      The AthenaTools Plotter Widget Set - Version 6.0
 *
 *      klin, Tue Jul  7 13:59:47 1992
 *      klin, Mon Jul 27 14:19:00 1992, patchlevel 2
 *                                      Draw() changed for drawing
 *                                      to a pixmap instead of a window
 *      klin, Sat Aug 15 10:31:50 1992, patchlevel 4
 *                                      Changed <At/..> to <X11/At/..>.
 *      klin, Thu Jan 28 14:14:35 1993, patchlevel 6
 *                                      AtTextMakros changed to handle
 *                                      NULL text .
 *      klin, Wed Sep  8 10:12:44 1993, patchlevel 8
 *                                      AtTextPSHeight() added.
 *                                      Some minor changes.
 *
 *      SCCSid[] = "@(#) Plotter V6.0  93/09/08  Text.h"
 */


#ifndef _At_Text_h
#define _At_Text_h

#include "At.h"
#include "FontFamily.h"

typedef struct _AtTextToken {
     struct _AtTextToken *next;
     int   type;
     int   code;
     char  *str;
     /* Formatting information */
     XFontStruct *font;            /* What font to draw it in */
     short width;                  /* Bounding box info */
     short ascent;
     short descent;
     short baseline;
} AtTextToken;

typedef struct _AtText {
     AtFontFamily *family;
     int   size;
     int   style;
     char  *str;
     AtTextToken *parsed;
     short width;                  /* Bounding box info */
     short ascent;
     short descent;
     Boolean rotated;
     XImage *rotated_image;
     unsigned int rotated_depth;
} AtText;

#define AtTextJUSTIFY_LEFT    0
#define AtTextJUSTIFY_TOP     0
#define AtTextJUSTIFY_CENTER  1
#define AtTextJUSTIFY_RIGHT   2
#define AtTextJUSTIFY_BOTTOM  2

#define AtTextWidth(t)   ((t) ? (t)->width : 0)
#define AtTextAscent(t)  ((t) ? (t)->ascent : 0)
#define AtTextDescent(t) ((t) ? (t)->descent : 0)
#define AtTextHeight(t)  ((t) ? (t)->ascent + (t)->descent: 0)

extern AtText* AtTextCreate(char *, AtFontFamily *, int, int);
extern void AtTextDestroy(AtText *);
extern void AtTextFormat(AtText *, AtFontFamily *, int, int);
extern void AtTextReformat(AtText *, AtFontFamily *, int, int);
extern void AtTextRotate(AtText *);
extern void AtTextDraw(Display *, Window, Drawable, GC, AtText *, int, int);
extern void AtTextDrawJustified(Display *, Window, Drawable, GC, AtText *,
				   int, int, int, int, int, int);
extern void AtTextWritePostscriptProlog(FILE *);

#endif /* _At_Text_h */
