/*
 *      Shading.h
 *
 *      The AthenaTools Plotter Widget Set - Version 6.0
 *
 *      klin, Tue Jul  7 13:59:47 1992
 *      klin, Sat Aug 15 10:31:50 1992, patchlevel 4
 *                                      Changed <At/..> to <X11/At/..>.
 *      klin, Fri Jul 23 17:41:23 1993, patchlevel 8
 *                                      Some minor changes.
 *
 *      SCCSid[] = "@(#) Plotter V6.0  93/07/23  Shading.h"
 */


/*
 * Specify Grayscale and stippling in a manner that is compatable
 * between printers and X
 */

#ifndef _At_Shading_h
#define _At_Shading_h

#include "At.h"

typedef enum {
     AtGRAY0,
     AtGRAY1,
     AtGRAY2,
     AtGRAY3,
     AtGRAY4,
     AtGRAY5,
     AtGRAY6,
     AtGRAY7,
     AtGRAY8,
     AtGRAY9,
     AtGRAY10
} AtShading;

#define XtNshading "shading"

#define XtRShading "Shading"

#define XtCShading "Shading"


/*
 * Some routines to access the gray information
 *
 * The first two implement a cache of pixmaps, one pixmap per screen
 * per gray level.  The pixmaps are ref counted so they can be
 * released, saving server resources.
 *
 * The PostScript routine writes to the specified file a string that
 * sets the postscript graphics state so that a fill operation will
 * have the required apearance.
 *
 * The last is a routine to register a string to Shading converter.
 */

extern Pixmap AtShadingGetPixmap(Screen *, AtShading, Pixel, Pixel);
extern void AtShadingReleasePixmap(Pixmap);
extern char *AtShadingPS(AtShading);
extern void AtRegisterShadingConverter(void);

#endif /* _At_Shading_h */
