/*
 *      Scale.h
 *
 *      The AthenaTools Plotter Widget Set - Version 6.0
 *
 *      klin, Tue Jul  7 13:59:47 1992
 *      klin, Sat Aug 15 10:31:50 1992, patchlevel 4
 *                                      Changed <At/..> to <X11/At/..>.
 *      klin, Fri Jul 23 17:41:23 1993, patchlevel 8
 *                                      Some minor changes.
 *
 *      SCCSid[] = "@(#) Plotter V6.0  93/07/23  Scale.h"
 */


#ifndef _At_Scale_h
#define _At_Scale_h

#include "At.h"

typedef enum {
     AtTransformLINEAR,
     AtTransformLOGARITHMIC,
     AtTransformINVALID
} AtTransform;

typedef struct {
     double low, high;
     int lowpix, highpix;
     AtTransform transform;
     double mult, offset;
     int errorcode;
} AtScale;

#define SCALEERROR_NONE            0
#define SCALEERROR_BOUNDLESS       1
#define SCALEERROR_BOUNDCLOSE      2
#define SCALEERROR_LOGNEGATIVE     3
#define SCALEERROR_NOTRANSFORM     4

#define AtScaleGetLow(scale) (scale->low)
#define AtScaleGetHigh(scale) (scale->high)
#define AtScaleGetLowPix(scale) (scale->lowpix)
#define AtScaleGetHighPix(scale) (scale->highpix)
#define AtScaleGetTransform(scale) (scale->transform)
#define AtScaleGetErrorCode(scale) (scale->errorcode)

/* for use with X Toolkit resources and converters */

#define XtRTransform "Transform"

extern void AtRegisterTransformConverter(void);
extern AtScale *AtScaleCreate(double, double, int, int, AtTransform);
extern AtScale *AtScaleCopy(AtScale *);
extern void AtScaleDestroy(AtScale *);
extern void AtScaleResize(AtScale *, int, int);
extern void AtScaleRescale(AtScale *, double, double);
extern void AtScaleChangeTransform(AtScale *, AtTransform);
extern int AtScaleUserToPixel(AtScale *, double);
extern double AtScalePixelToUser(AtScale *, int);
extern char *AtScaleGetErrorMessage(AtScale *);
extern double _AtScaleAlmostZero;

#endif /* _At_Scale_h */
