/*
 *      XYPlotP.h
 *
 *      The AthenaTools Plotter Widget Set - Version 6.0
 *
 *      klin, Tue Jul  7 13:59:47 1992
 *      klin, Sat Aug 15 10:31:50 1992, patchlevel 4
 *                                      Resources XtNxOffest and XtNyOffset
 *                                      added
 *                                      Changed <At/..> to <X11/At/..>.
 *      klin, Sun Dec  5 19:57:38 1993, patchlevel 8
 *                                      Fast update and all stuff removed.
 *                                      New resources XtNreleaseWhenAttached,
 *                                      XtNallocateInSlices and
 *                                      XtNdrawAllWhenExtended.
 *                                      New private state variables for
 *                                      improving speed when extending data.
 *                                      Some minor changes.
 *
 *      SCCSid[] = "@(#) Plotter V6.0  93/12/05  XYPlotP.h"
 */


/*
 * Another pseudo class that sits between AtPlot and the line and bar
 * plots.  It provides all the resources required to access the data
 * using the elements of the structure.
 */

#ifndef _At_QuadPlotP_h
#define _At_QuadPlotP_h

#include "At.h"
#include "PlotP.h"
#include "QuadPlot.h"

typedef void (*AtQuadPlotAttachProc)(AtQuadPlotWidget, BoundingBox *, int);

typedef struct {
     AtQuadPlotAttachProc  attach_data;
} AtQuadPlotClassPart;

#define XtInheritAttachData ((AtQuadPlotAttachProc) _XtInherit)

typedef struct _AtQuadPlotClassRec {
     ObjectClassPart     object_class;
     AtPlotClassPart     plot_class;
     AtQuadPlotClassPart   lplot_class;
} AtQuadPlotClassRec;

extern AtQuadPlotClassRec atQuadPlotClassRec;

typedef struct {
     /* Resources */
     double         x_offset;
     double         y_offset;
     Boolean        release_when_attached;
     Boolean        allocate_in_slices;
     Boolean        draw_all_when_extended;
     /* Private State */
     XtPointer      xdata,ydata,z1data,z2data;
     AtDataType     xtype,ytype,z1type,z2type;
     Cardinal       xstride,ystride,z1stride,z2stride;
     Cardinal       start;
     /* The pointer to (one part of) the pixel data */
     Cardinal       num_points;
     XtPointer      pix;
     /* Indices for fast drawing when data are extended */
     int            draw_from;
     int            draw_to;
     /* Number of allocated items in pix */
     Cardinal       num_alloc;
     /* Number of calculated items in pix */
     int            num_calc;
} AtQuadPlotPart;

typedef struct _AtQuadPlotRec {
     ObjectPart     object;
     AtPlotPart     plot;
     AtQuadPlotPart   lplot;
} AtQuadPlotRec;

#endif /* _At_QuadPlotP_h */
