/*
 *      XYPlot.h
 *
 *      The AthenaTools Plotter Widget Set - Version 6.0
 *
 *      klin, Tue Jul  7 13:59:47 1992
 *      klin, Sat Aug 15 10:31:50 1992, patchlevel 4
 *                                      Resources XtNxOffest and XtNyOffset
 *                                      added.
 *                                      Changed <At/..> to <X11/At/..>.
 *      klin, Tue Dec  7 15:47:57 1993, patchlevel 8
 *                                      Typo fixed (by S. J. Manani).
 *                                      Fast update and all stuff removed.
 *                                      New resources XtNreleaseWhenAttached,
 *                                      XtNallocateInSlices and
 *                                      XtNdrawAllWhenExtended.
 *                                      AtXYPlotGetNumPoints() added.
 *                                      Some minor changes.
 *
 *      SCCSid[] = "@(#) Plotter V6.0  93/12/07  XYPlot.h"
 */


/* AtQuadPlot is  non-instanced class that contains resources and routines
 * for accessing data that is currently stored in an array of structures.  */

#ifndef _At_QuadPlot_h
#define _At_QuadPlot_h

#include "At.h"
#include "AtConverters.h"
#include "Plot.h"


/* Declare specific AtQuadPlotWidget class and instance datatypes */

typedef struct _AtQuadPlotClassRec*  AtQuadPlotWidgetClass;
typedef struct _AtQuadPlotRec*       AtQuadPlotWidget;


/* Declare the class constant */

extern WidgetClass atQuadPlotWidgetClass;

#ifndef AtIsQuadPlot
#define AtIsQuadPlot(w)    XtIsSubclass(w, atQuadPlotWidgetClass)
#endif


/* Resources available to be set/fetched */

#define XtNxOffset "xOffset"
#define XtNyOffset "yOffset"
#define XtNdrawAllWhenExtended "drawAllWhenExtended"
#define XtNallocateInSlices "allocateInSlices"
#define XtNreleaseWhenAttached "releaseWhenAttached"

#define XtCXOffset "XOffset"
#define XtCYOffset "YOffset"
#define XtCDrawAllWhenExtended "DrawAllWhenExtended"
#define XtCAllocateInSlices "AllocateInSlices"
#define XtCReleaseWhenAttached "ReleaseWhenAttached"


/*   The error bar types */

typedef enum {
     AtSideUPPER,
     AtSideLOWER,
     AtSideAWAY,
     AtSideTOWARDS,
     AtSideBOTH,
     AtSideINVALID
} AtPlotSide;


/* The member routine to attach the data.
 * The subclasses of AtXPlot export a #define for this routine.  */

extern int AtQuadPlotAttachData(Widget, XtPointer, AtDataType, Cardinal,
            XtPointer, AtDataType, Cardinal,
            XtPointer, AtDataType, Cardinal,
            XtPointer, AtDataType, Cardinal, Cardinal, Cardinal);
extern void AtQuadPlotExtendData(Widget, Cardinal);


/* Return the number of points of the attached data.  */

extern Cardinal AtQuadPlotGetNumPoints(Widget);

/* Get the i'th value from the AtQuadPlot data.  This declares the function
 * version, a macro is available below.  This is intended mainly for
 * subclasses of AtQuadPlot, but applications may find it useful.  */

extern double AtQuadPlotGetXValue(AtQuadPlotWidget, Cardinal);
extern double AtQuadPlotGetYValue(AtQuadPlotWidget, Cardinal);
extern double AtQuadPlotGetZ1Value(AtQuadPlotWidget, Cardinal);
extern double AtQuadPlotGetZ2Value(AtQuadPlotWidget, Cardinal);


/* A macro version of the above.  May be faster, but death to debug! */

/* First, get the address of the i'th element */

#define _lp_xptr(p, i) ((XtPointer)((char *)p->lplot.xdata + \
				    p->lplot.xstride * (i)))
#define _lp_yptr(p, i) ((XtPointer)((char *)p->lplot.ydata + \
				    p->lplot.ystride * (i)))
#define _lp_z1ptr(p, i) ((XtPointer)((char *)p->lplot.z1data + \
				    p->lplot.z1stride * (i)))
#define _lp_z2ptr(p, i) ((XtPointer)((char *)p->lplot.z2data + \
				    p->lplot.z2stride * (i)))

#if(0)  /* use functional versions for now */
#define AtQuadPlotGetXValue(p, i) \
     ((p)->lplot.x_offset + (double) \
      ((p)->lplot.xtype == AtDouble ? *((double *)_lp_xptr((p), (i))) : \
       (p)->lplot.xtype == AtFloat ? (double)*((float *)_lp_xptr((p), (i))) : \
       (p)->lplot.xtype == AtInt ? (double)*((int *)_lp_xptr((p), (i))) : \
       (p)->lplot.xtype == AtShort ? (double)*((short *)_lp_xptr((p), (i))) : \
				0.0))

#define AtQuadPlotGetYValue(p, i) \
     ((p)->lplot.y_offset + (double) \
      ((p)->lplot.ytype == AtDouble ? *((double *)_lp_yptr((p), (i))) : \
       (p)->lplot.ytype == AtFloat ? (double)*((float *)_lp_yptr((p), (i))) : \
       (p)->lplot.ytype == AtInt ? (double)*((int *)_lp_yptr((p), (i))) : \
       (p)->lplot.ytype == AtShort ? (double)*((short *)_lp_yptr((p), (i))) : \
				0.0))

#define AtQuadPlotGetZValue(p, i) \
     ((p)->lplot.z_offset + (double) \
      ((p)->lplot.ztype == AtDouble ? *((double *)_lp_zptr((p), (i))) : \
       (p)->lplot.ztype == AtFloat ? (double)*((float *)_lp_zptr((p), (i))) : \
       (p)->lplot.ztype == AtInt ? (double)*((int *)_lp_zptr((p), (i))) : \
       (p)->lplot.ztype == AtShort ? (double)*((short *)_lp_zptr((p), (i))) : \
				0.0))
#endif

#endif /* _At_QuadPlot_h */
