/*
 *      XYPlot.c
 *
 *      The AthenaTools Plotter Widget Set - Version 6.0
 *
 *      klin, Tue Jul  7 13:59:47 1992
 *      klin, Mon Jul 27 14:19:54 1992, patchlevel 2
 *                                      Shorter names for procedures
 *      klin, Sat Aug 15 10:31:50 1992, patchlevel 4
 *                                      Resources XtNxOffest and XtNyOffset
 *                                      and all needed stuff added
 *                                      Changed <At/..> to <X11/At/..>.
 *      klin, Fri Feb 12 08:55:19 1993, patchlevel 7
 *                                      Bug in setting double resources fixed
 *      klin, Sun Dec  5 19:56:29 1993, patchlevel 8
 *                                      Fast update and all stuff removed.
 *                                      New resources XtNreleaseWhenAttached,
 *                                      XtNallocateInSlices and
 *                                      XtNdrawAllWhenExtended.
 *                                      New private state variables for
 *                                      improving speed when extending data.
 *                                      Some minor changes.
 */
static char SCCSid[] = "@(#) Plotter V6.0  93/12/05  XYPlot.c";


/*
 *   The AtXYPlot object is simply a holder for some resources to allow
 *   access to data items that are elements of a structure or an array.
 */

#include "QuadPlotP.h"

double AtQuadPlotGetXValue(AtQuadPlotWidget p, Cardinal i)
{
	XtPointer ptr;
	double ret;

	if (p->lplot.xdata == NULL)
		ret = (double) i;
	else {
		ptr = _lp_xptr(p, i);

		ret = (p)->lplot.x_offset +
					((p)->lplot.xtype == AtDouble ? *((double *) ptr) :
					(p)->lplot.xtype == AtFloat ? (double) *((float *) ptr) :
					(p)->lplot.xtype == AtInt ? (double) *((int *) ptr) :
					(p)->lplot.xtype == AtShort ? (double) *((short *) ptr) :
					0.0);
	}

	return (ret);
}

double AtQuadPlotGetYValue(AtQuadPlotWidget p, Cardinal i)
{
	XtPointer ptr = _lp_yptr(p, i);
	double ret;

	ret = (p)->lplot.y_offset +
				((p)->lplot.ytype == AtDouble ? *((double *) ptr) :
				(p)->lplot.ytype == AtFloat ? (double) *((float *) ptr) :
				(p)->lplot.ytype == AtInt ? (double) *((int *) ptr) :
				(p)->lplot.ytype == AtShort ? (double) *((short *) ptr) :
				0.0);

	return (ret);
}

double AtQuadPlotGetZ1Value(AtQuadPlotWidget p, Cardinal i)
{
	XtPointer ptr;
	double ret;

	if (p->lplot.z1data == NULL)
		ret = 0.0;
	else {
		ptr = _lp_z1ptr(p, i);

		ret =
					((p)->lplot.z1type == AtDouble ? *((double *) ptr) :
					(p)->lplot.z1type == AtFloat ? (double) *((float *) ptr) :
					(p)->lplot.z1type == AtInt ? (double) *((int *) ptr) :
					(p)->lplot.z1type == AtShort ? (double) *((short *) ptr) :
					0.0);
	}

	return (ret);
}

double AtQuadPlotGetZ2Value(AtQuadPlotWidget p, Cardinal i)
{
	XtPointer ptr;
	double ret;

	if (p->lplot.z2data == NULL)
		ret = 0.0;
	else {
		ptr = _lp_z2ptr(p, i);

		ret =
					((p)->lplot.z2type == AtDouble ? *((double *) ptr) :
					(p)->lplot.z2type == AtFloat ? (double) *((float *) ptr) :
					(p)->lplot.z2type == AtInt ? (double) *((int *) ptr) :
					(p)->lplot.z2type == AtShort ? (double) *((short *) ptr) :
					0.0);
	}

	return (ret);
}

static void Destroy(AtQuadPlotWidget);
static void ClassPartInitialize(WidgetClass);
static void Initialize(AtQuadPlotWidget, AtQuadPlotWidget);
static Boolean SetValues(AtQuadPlotWidget, AtQuadPlotWidget, AtQuadPlotWidget);


/*  The resources */

static double dflt_offset = 0.0;

#define off(field) XtOffsetOf (AtQuadPlotRec, lplot.field)
static XtResource resources[] =
{
			{
						XtNxOffset, XtCXOffset,
						XtRDouble, sizeof(double),
						off(x_offset), XtRDouble, (XtPointer) & dflt_offset
			},
			{
						XtNyOffset, XtCYOffset,
						XtRDouble, sizeof(double),
						off(y_offset), XtRDouble, (XtPointer) & dflt_offset
			},
			{
						XtNreleaseWhenAttached, XtCReleaseWhenAttached,
						XtRBoolean, sizeof(Boolean),
						off(release_when_attached), XtRImmediate, (XtPointer) True
			},
			{
						XtNallocateInSlices, XtCAllocateInSlices,
						XtRBoolean, sizeof(Boolean),
						off(allocate_in_slices), XtRImmediate, (XtPointer) False
			},
			{
						XtNdrawAllWhenExtended, XtCDrawAllWhenExtended,
						XtRBoolean, sizeof(Boolean),
						off(draw_all_when_extended), XtRImmediate, (XtPointer) False
			},
};
#undef  off

AtQuadPlotClassRec atQuadPlotClassRec =
{
			{													/* core fields */
		/* superclass               */ (WidgetClass) & atPlotClassRec,
		/* class_name               */ "AtQuadPlot",
		/* widget_size              */ sizeof(AtQuadPlotRec),
		/* class_initialize         */ NULL,
		/* class_part_initialize    */ ClassPartInitialize,
		/* class_inited             */ FALSE,
		/* initialize               */ (XtInitProc) Initialize,
		/* initialize_hook          */ NULL,
		/* pad                      */ NULL,
		/* pad                      */ NULL,
		/* pad                      */ 0,
		/* resources                */ resources,
		/* num_resources            */ XtNumber(resources),
		/* xrm_class                */ NULLQUARK,
		/* pad                      */ FALSE,
		/* pad                      */ FALSE,
		/* pad                      */ FALSE,
		/* pad                      */ FALSE,
		/* destroy                  */ (XtWidgetProc) Destroy,
		/* pad                      */ NULL,
		/* pad                      */ NULL,
		/* set_values               */ (XtSetValuesFunc) SetValues,
		/* set_values_hook          */ NULL,
		/* pad                      */ NULL,
		/* get_values_hook          */ NULL,
		/* pad                      */ NULL,
		/* version                  */ XtVersion,
		/* callback_private         */ NULL,
		/* pad                      */ NULL,
		/* pad                      */ NULL,
		/* pad                      */ NULL,
		/* pad                      */ NULL
			},
			{													/* atPlot fields */
		/* draw                     */ NULL,
		/* draw_icon                */ NULL,
		/* recalc                   */ NULL
			},
			{													/* lPlot fields */
		/* attach_data              */ NULL
			}
};

WidgetClass atQuadPlotWidgetClass = (WidgetClass) & atQuadPlotClassRec;


/*    The class initialize/initialize/destroy/setvalues procs */

static void ClassPartInitialize(wc)
		 WidgetClass wc;
{
	AtQuadPlotWidgetClass super = (AtQuadPlotWidgetClass) wc->core_class.superclass;
	AtQuadPlotWidgetClass spc = (AtQuadPlotWidgetClass) wc;
	if (spc->lplot_class.attach_data == XtInheritAttachData) {
		spc->lplot_class.attach_data = super->lplot_class.attach_data;
	}
}

static void Initialize(req, new)
		 AtQuadPlotWidget req, new;
{
	AtQuadPlotPart *sr = &new->lplot;

	sr->xdata = sr->ydata = NULL;
	sr->xstride = sr->ystride = sr->start = sr->num_points = 0;
	sr->xtype = sr->ytype = AtInt;
	sr->pix = NULL;
	sr->draw_from = 0;
	sr->draw_to = -1;
	sr->num_alloc = 0;
	sr->num_calc = 0;
}

static void Destroy(sp)
		 AtQuadPlotWidget sp;
{
	/* Currently, there is nothing to do */
	*SCCSid = *SCCSid;						/* Keep gcc quiet */
}

static Boolean SetValues(current, request, new)
		 AtQuadPlotWidget current, request, new;
{
#define Changed(field) (new->lplot.field != current->lplot.field)
	BoundingBox bb;
	int i;

	if (Changed(x_offset) || Changed(y_offset)) {
		bb.xmax = bb.ymax = -HUGE_VAL;
		bb.xmin = bb.ymin = HUGE_VAL;
		for (i = 0; i < new->lplot.num_points; i++) {
			register double v;
			v = AtQuadPlotGetXValue(new, i);
			bb.xmax = Max(bb.xmax, v);
			bb.xmin = Min(bb.xmin, v);
			v = AtQuadPlotGetYValue(new, i);
			bb.ymax = Max(bb.ymax, v);
			bb.ymin = Min(bb.ymin, v);
		}
		AtPlotterPlotDataChanged((Widget) new, &bb, False);
	}

	/* Nothing to redisplay */
	return False;
#undef Changed
}


/*  These are the exported "member" routines */

int AtQuadPlotAttachData(Widget w,
			XtPointer xdata, AtDataType xtype, Cardinal xstride,
			XtPointer ydata, AtDataType ytype, Cardinal ystride,
			XtPointer z1data, AtDataType z1type, Cardinal z1stride,
			XtPointer z2data, AtDataType z2type, Cardinal z2stride,
			Cardinal start, Cardinal num)
{
	AtQuadPlotWidget spw = (AtQuadPlotWidget) w;
	BoundingBox bb;
	AtQuadPlotAttachProc adp;

	XtCheckSubclass((Widget) spw, atQuadPlotWidgetClass,
				"AtQuadPlotAttachData needs an AtQuadPlot object");

	spw->lplot.start = start;
	spw->lplot.num_points = num;
	spw->lplot.xdata = xdata;
	spw->lplot.xtype = xtype;
	spw->lplot.xstride = xstride;
	spw->lplot.ydata = ydata;
	spw->lplot.ytype = ytype;
	spw->lplot.ystride = ystride;
	spw->lplot.z1data = z1data;
	spw->lplot.z1type = z1type;
	spw->lplot.z1stride = z1stride;
	spw->lplot.z2data = z2data;
	spw->lplot.z2type = z2type;
	spw->lplot.z2stride = z2stride;

	if ((adp = ((AtQuadPlotWidgetClass)
						spw->object.widget_class)->lplot_class.attach_data) != NULL)
		adp(spw, &bb, False);

	AtPlotterPlotDataChanged((Widget) spw, &bb, False);
	return (1);
}


/*   We have added some more data, num is the new total
 *   Data runs from 0 .. num-1, where x value of first is start.  */

void AtQuadPlotExtendData(w, num)
		 Widget w;
		 Cardinal num;
{
	AtQuadPlotWidget spw = (AtQuadPlotWidget) w;
	BoundingBox bb;
	AtQuadPlotAttachProc adp;
	int i;
	int old_num = spw->lplot.num_points;

	XtCheckSubclass((Widget) spw, atQuadPlotWidgetClass,
				"AtQuadPlotExtendData needs an AtQuadPlot object");

	if (spw->lplot.xdata == NULL || spw->lplot.ydata == NULL) {
		XtAppWarning(XtWidgetToApplicationContext(w),
					"There are no data attached to this AtQuadPlot widget");
		return;
	}

	bb.xmax = bb.ymax = -HUGE_VAL;
	bb.xmin = bb.ymin = HUGE_VAL;

	/* Get the BBox for THE NEW STUFF ONLY */
	for (i = old_num; i < num; i++) {
		register double v;
		v = AtQuadPlotGetXValue(spw, i);
		bb.xmax = Max(bb.xmax, v);
		bb.xmin = Min(bb.xmin, v);
		v = AtQuadPlotGetYValue(spw, i);
		bb.ymax = Max(bb.ymax, v);
		bb.ymin = Min(bb.ymin, v);
	}
	spw->lplot.num_points = num;

	if ((adp = ((AtQuadPlotWidgetClass)
										spw->object.widget_class)->lplot_class.attach_data) != NULL) {
		adp(spw, &bb, True);
	}

	AtPlotterPlotExtended((Widget) spw, &bb, old_num, num - 1);
}


/*  Return the number of attached data points.  */

Cardinal AtQuadPlotGetNumPoints(w)
		 Widget w;
{
	AtQuadPlotWidget spw = (AtQuadPlotWidget) w;

	XtCheckSubclass((Widget) spw, atQuadPlotWidgetClass,
				"AtQuadPlotExtendData needs an AtQuadPlot object");

	return spw->lplot.num_points;
}
