/*
 *      XYLinePlotP.h
 *
 *      The AthenaTools Plotter Widget Set - Version 6.0
 *
 *      klin, Tue Jul  7 13:59:47 1992
 *      klin, Sat Aug 15 10:31:50 1992, patchlevel 4
 *                                      Changed <At/..> to <X11/At/..>.
 *      klin, Thu Dec 30 16:47:21 1993, patchlevel 8
 *                                      New resource XtNmarkColor added.
 *                                      Some minor changes.
 *
 *      SCCSid[] = "@(#) Plotter V6.0  93/12/30  XYLinePlotP.h"
 */

#ifndef _At_QuadLinePlotP_h
#define _At_QuadLinePlotP_h

#include "At.h"
#include "QuadPlotP.h"
#include "QuadLinePlot.h"

typedef struct {
     int  empty;
} AtQuadLinePlotClassPart;

typedef struct _AtQuadLinePlotClassRec {
     ObjectClassPart          object_class;
     AtPlotClassPart          plot_class;
     AtQuadPlotClassPart        lplot_class;
     AtQuadLinePlotClassPart    xyplot_class;
} AtQuadLinePlotClassRec;

extern AtQuadLinePlotClassRec atQuadLinePlotClassRec;

typedef struct {
     /* Ressources */
     AtPlotType      type;
     AtPlotLine      line;
     AtPlotMark      mark;
     Pixel           color;
     double          mark_guage;
     Boolean         mark_fill;
     AtPlotSide      err_bar_side;
     double					 err_bar_size;

     /* Private state */
     short               impulse_y;
     GC                  line_gc;
     GC                  mark_gc;
} AtQuadLinePlotPart;

typedef struct _AtQuadLinePlotRec {
     ObjectPart          object;
     AtPlotPart          plot;
     AtQuadPlotPart        qplot;
     AtQuadLinePlotPart    lplot;
} AtQuadLinePlotRec;

typedef struct {
  short x, y, z1, z2;
} AtQuadPoint;

#endif /* _At_QuadLinePlotP_h */
