/*
 *      XYLinePlot.h
 *
 *      The AthenaTools Plotter Widget Set - Version 6.0
 *
 *      klin, Tue Jul  7 13:59:47 1992
 *      klin, Mon Jul 27 14:19:43 1992, patchlevel 2
 *                                      Plot types steps and bars added
 *      klin, Sat Aug 15 10:31:50 1992, patchlevel 4
 *                                      Changed <At/..> to <X11/At/..>.
 *      klin, Thu Dec 30 16:47:21 1993, patchlevel 8
 *                                      New resource XtNmarkColor added.
 *                                      Line types SEGMENTS and SEGMENTPOINTS,
 *                                      mark styles DOT, CIRCLE, HORIZONTALBAR
 *                                      and VERTICALBAR added (by Jamie Mazer).
 *                                      AtXYLinePlotGetNumPoints() added.
 *                                      Some minor changes.
 *
 *      SCCSid[] = "@(#) Plotter V6.0  93/12/30  XYLinePlot.h"
 */

/*   The more complicated sort of plot.
 *   A line connecting the X and Y values attached to the axes.  */

#ifndef _At_QuadLinePlot_h
#define _At_QuadLinePlot_h

#include "At.h"
#include "QuadPlot.h"

/*   Resources available to be set/fetched */

#define XtNplotType		"plotType"
#define XtNplotLine		"plotLine"
#define XtNplotMark		"plotMark"
#define XtNplotColor	"plotColor"
#define XtNmarkGuage	"markGuage"
#define XtNmarkFill		"markFill"
#define XtNerrBarSide "errBarSide"
#define XtNerrBarSize "errBarSize"

#define XtCPlotType		"PlotType"
#define XtCPlotLine		"PlotLine"
#define XtCPlotMark		"PlotMark"
#define XtCMarkGuage	"MarkGuage"
#define XtCMarkFill		"MarkFill"
#define XtCErrBarSide   "ErrBarSide"
#define XtCErrBarSize   "ErrBarSize"

#define XtRPlotType		"PlotType"
#define XtRPlotLine		"PlotLine"
#define XtRPlotMark		"PlotMark"
#define XtRErrBarSide "ErrBarSide"

/* Declare specific AtQuadLinePlotWidget class and instance datatypes */

typedef struct _AtQuadLinePlotClassRec*   AtQuadLinePlotWidgetClass;
typedef struct _AtQuadLinePlotRec*        AtQuadLinePlotWidget;

/* Declare the class constant */

extern WidgetClass atQuadLinePlotWidgetClass;

#ifndef AtIsQuadLinePlot
#define AtIsQuadLinePlot(w)   XtIsSubclass(w, atQuadLinePlotWidgetClass)
#endif

/*   The plot line types */

typedef enum {
     AtTypeLINES,             /* lines, default */
     AtTypePOINTS,            /* points */
     AtTypeIMPULSES,          /* impulses */
     AtTypeSEGMENTS,          /* line segments */
     AtTypeLINEPOINTS,        /* lines with points */
     AtTypeLINEIMPULSES,      /* lines with impulses */
     AtTypeSEGMENTPOINTS,     /* segments with points */
     AtTypeINVALID            /* invalid: use default */
} AtPlotType;


/*   The plot line styles */

typedef enum {
     AtLineSOLID,             /* solid, default */
     AtLineDOTTED,            /* dotted 1 */
     AtLineDASHED,            /* dashed 2 */
     AtLineDOTDASHED,         /* dot dashed 1 */
     AtLineDOTTED2,           /* dotted 2 */
     AtLineDOTTED3,           /* dotted 3 */
     AtLineDOTTED4,           /* dotted 4 */
     AtLineDOTTED5,           /* dotted 5 */
     AtLineDASHED3,           /* dashed 3 */
     AtLineDASHED4,           /* dashed 4 */
     AtLineDASHED5,           /* dashed 5 */
     AtLineDOTDASHED2,        /* dot dashed 2 */
     AtLineINVALID            /* invalid: use default */
} AtPlotLine;


/*   The plot marker types */

typedef enum {
     AtMarkSQUARE,            /* rectangle, default */
     AtMarkDOT,               /* plain dots */
     AtMarkCIRCLE,            /* circle */
     AtMarkPLUS,              /* plus sign */
     AtMarkXMARK,             /* x-mark sign */
     AtMarkSTAR,              /* star */
     AtMarkDIAMOND,           /* diamond */
     AtMarkTRIANGLE1,         /* bottom triangle */
     AtMarkTRIANGLE2,         /* top triangle */
     AtMarkTRIANGLE3,         /* left triangle */
     AtMarkTRIANGLE4,         /* right triangle */
     AtMarkHBAR,     /* horizontal bar */
     AtMarkVBAR,       /* vertical bar */
     AtMarkINVALID            /* invalid: use default */
} AtPlotMark;


/*   Some types for attaching data made easy */

typedef struct {
     double x;
     double y;
} AtDoublePoint;

typedef struct {
     float x;
     float y;
} AtFloatPoint;

typedef struct {
     int x;
     int y;
} AtIntPoint;

typedef struct {
     short x;
     short y;
} AtShortPoint;


/*   Creation function */

extern Widget AtCreateQuadLinePlot(Widget, char *, Arg *, Cardinal);


/*   The member procedures. These ones are inherited from QuadPlot */

#define AtQuadLinePlotAttachData(w, xp,xt,xstride, yp,yt,ystride, \
			z1p,z1t,z1stride, z2p,z2t,z2stride, start,num) \
		AtQuadPlotAttachData((Widget) w, xp,xt,xstride, yp,yt,ystride, \
			z1p,z1t,z1stride, z2p,z2t,z2stride, start,num)
#define AtQuadLinePlotExtendData(w, n) \
     AtQuadPlotExtendData((Widget) w, n)

#define AtQuadLinePlotGetNumPoints(w)     AtQuadGetNumPoints((Widget) w)


/*   The member procedures for AtxxPoint data */

#define AtQuadLinePlotAttachDoublePoints(w, data, start, num) \
     AtQuadPlotAttachData((Widget) w, \
	  (XtPointer) &(data)->x, AtDouble, sizeof(AtDoublePoint), \
	  (XtPointer) &(data)->y, AtDouble, sizeof(AtDoublePoint), \
	  (XtPointer) &(data)->z1, AtDouble, sizeof(AtDoublePoint), \
	  (XtPointer) &(data)->z2, AtDouble, sizeof(AtDoublePoint), \
	  start, num)

#define AtQuadLinePlotAttachFloatPoints(w, data, start, num) \
     AtQuadPlotAttachData((Widget) w, \
	  (XtPointer) &(data)->x, AtFloat, sizeof(AtFloatPoint), \
	  (XtPointer) &(data)->y, AtFloat, sizeof(AtFloatPoint), \
	  (XtPointer) &(data)->z1, AtFloat, sizeof(AtFloatPoint), \
	  (XtPointer) &(data)->z2, AtFloat, sizeof(AtFloatPoint), \
	  start, num)

#define AtQuadLinePlotAttachIntPoints(w, data, start, num) \
     AtQuadPlotAttachData((Widget) w, \
	  (XtPointer) &(data)->x, AtInt, sizeof(AtIntPoint), \
	  (XtPointer) &(data)->y, AtInt, sizeof(AtIntPoint), \
	  (XtPointer) &(data)->z1, AtInt, sizeof(AtIntPoint), \
	  (XtPointer) &(data)->z2, AtInt, sizeof(AtIntPoint), \
	  start, num)

#define AtQuadLinePlotAttachShortPoints(w, data, start, num) \
     AtQuadPlotAttachData((Widget) w, \
	  (XtPointer) &(data)->x, AtShort, sizeof(AtShortPoint), \
	  (XtPointer) &(data)->y, AtShort, sizeof(AtShortPoint), \
	  (XtPointer) &(data)->z1, AtShort, sizeof(AtShortPoint), \
	  (XtPointer) &(data)->z2, AtShort, sizeof(AtShortPoint), \
	  start, num)

#endif /* _At_QuadLinePlot_h */
