/*
 *      XYLabelAxis.c
 *
 *      The AthenaTools Plotter Widget Set - Version 6.0
 *
 *      klin, Thu Sep  9 10:25:37 1993
 */
static char SCCSid[] = "@(#) Plotter V6.0  93/09/09  XYLabelAxis.c";


/*
 *   Teh QuadLabel Axis widget is derived from the LabelAxis widget and
 *   is a subclass of the AxisCore widget class.
 *   The QuadLabelAxis class decides the location and label of the tic
 *   marks by looking at the application-supplied data.
 */


#include "QuadLabelAxisP.h"

static void Initialize(AtQuadLabelAxisWidget, AtQuadLabelAxisWidget);
static Boolean SetValues(AtQuadLabelAxisWidget, AtQuadLabelAxisWidget,
			    AtQuadLabelAxisWidget);
static void RangeProc(AtAxisCoreWidget, double *minp, double *maxp,
			 double *tip, int *nwp);
static void CalcProc(AtAxisCoreWidget);

/* No new resources */

AtQuadLabelAxisClassRec atQuadLabelAxisClassRec = {
  { /* core fields */
     /* superclass              */      (WidgetClass) &atAxisCoreClassRec,
     /* class_name              */      "AtQuadLabelAxis",
     /* widget_size             */      sizeof(AtQuadLabelAxisRec),
     /* class_initialize        */      NULL,
     /* class_part_initialize   */      NULL,
     /* class_inited            */      FALSE,
     /* initialize              */      (XtInitProc) Initialize,
     /* initialize_hook         */      NULL,
     /* pad                     */      NULL,
     /* pad                     */      NULL,
     /* pad                     */      0,
     /* resources               */      NULL,
     /* num_resources           */      0,
     /* xrm_class               */      NULLQUARK,
     /* pad                     */      FALSE,
     /* pad                     */      FALSE,
     /* pad                     */      FALSE,
     /* pad                     */      FALSE,
     /* destroy                 */      NULL,
     /* pad                     */      NULL,
     /* pad                     */      NULL,
     /* set_values              */      (XtSetValuesFunc) SetValues,
     /* set_values_hook         */      NULL,
     /* pad                     */      NULL,
     /* get_values_hook         */      NULL,
     /* pad                     */      NULL,
     /* version                 */      XtVersion,
     /* callback_private        */      NULL,
     /* pad                     */      NULL,
     /* pad                     */      NULL,
     /* pad                     */      NULL,
     /* pad                     */      NULL
     },
  { /* atPlot fields */
     /* draw                    */      XtInheritDraw,
     /* draw_icon               */      XtInheritDrawIcon,
     /* recalc                  */      XtInheritRecalc
  },
  { /* labelAxis fields */
     /* range_proc              */      (AtAxisRangeProc) RangeProc,
     /* calc_proc               */      (AtAxisCalcProc) CalcProc
  }
};

WidgetClass atQuadLabelAxisWidgetClass = (WidgetClass)&atQuadLabelAxisClassRec;

/*
 *   The core member procs
 */

static void Initialize(req, new)
AtQuadLabelAxisWidget req, new;
{
     new->laxis.start = new->laxis.num_items = 0;
     new->laxis.first = new->laxis.last = 0;
     *SCCSid = *SCCSid;       /* Keep gcc quiet */
}

static Boolean SetValues(old, req, new)
AtQuadLabelAxisWidget old, req, new;
{
#define Changed(fld)     (old->laxis.fld != new->laxis.fld)
#define AC_Changed(fld)  (old->axiscore.fld != new->axiscore.fld)
     Boolean renum = False;

     if (AC_Changed(font_family) || AC_Changed(number_size)) {
	  renum = True;
     }

     if (renum) {
	  new->axiscore.numbers_changed = True;
	  AtPlotterRescaleRequired((Widget) new);
     }
     return False;

#undef Changed
#undef AC_Changed
}

/*
 *   Useful macros to access the label axis x value and label
 */

#define _la_ptr(p, i) \
     ((XtPointer) ((char *) p->laxis.xdata + p->laxis.xstride * (i)))

#define AxisXValue(p, i) \
    ((double) \
     ((p)->laxis.xtype == AtDouble ? *((double *)_la_ptr((p), (i))) : \
      (p)->laxis.xtype == AtFloat ? (double)*((float *)_la_ptr((p), (i))) : \
      (p)->laxis.xtype == AtInt ? (double)*((int *)_la_ptr((p), (i))) : \
      (p)->laxis.xtype == AtShort ? (double)*((short *)_la_ptr((p), (i))) : \
				0.0))

#define AxisLabel(p, i) \
     ((String *) ((char *) (p)->laxis.ldata + (p)->laxis.lstride * (i)))

/*
 *   The QuadLabelAxis member procs
 */

static Boolean CheckData(AtQuadLabelAxisWidget, AtQuadLabelAxisPart *);
static Boolean CheckData(lw, la)
AtQuadLabelAxisWidget lw;
AtQuadLabelAxisPart *la;
{
     if (!la->xdata || !la->ldata || la->start == 0 || la->num_items == 0) {
	  XtAppWarning(XtWidgetToApplicationContext(XtParent((Widget) lw)),
		       "No data attached to AtQuadLabelAxis");
	  return False;
     }
     return True;
}

static void RangeProc(w, minp, maxp, tip, nwp)
AtAxisCoreWidget w;
double *minp, *maxp, *tip;
int *nwp;
{
     AtQuadLabelAxisWidget lw = (AtQuadLabelAxisWidget) w;
     AtQuadLabelAxisPart *la = &((AtQuadLabelAxisWidget) w)->laxis;
     AtAxisCorePart *ac = &w->axiscore;
     double f, l;
     int ft, lt, i;

     /* Check attached data */
     if (!CheckData(lw, la))
	  return;

     /* Get and set first and last tic */
     la->first = la->start - 1;
     la->last  = la->first + la->num_items - 1;

     if (!w->axiscore.auto_scale) {
	  ft = la->first;
	  lt = la->last;
	  for (i = ft; i <= lt; i++) {
	       if (AxisXValue(lw, i) >= ac->max) {
		    la->last = i;
		    break;
	       }
	  }
	  for (i = lt; i >= ft; i--) {
	       if (AxisXValue(lw, i) <= ac->min) {
		    la->first = i;
		    break;
	       }
	  }
     }

     f = AxisXValue(lw, la->first);
     l = AxisXValue(lw, la->last);
     *minp = Min(f, l);
     *maxp = Max(l, f);
     *tip = 0.0;

     ac->min = *minp * 1.01;       /* Force recalc */
     ac->max = *maxp * 0.99;
}

static void CalcProc(w)
AtAxisCoreWidget w;
{
     AtQuadLabelAxisWidget lw = (AtQuadLabelAxisWidget) w;
     AtQuadLabelAxisPart *la = &((AtQuadLabelAxisWidget) w)->laxis;
     AtAxisCorePart *ac = &w->axiscore;
     int nt, ti, i;
     String *l;

     /* Check attached data */
     if (!CheckData(lw, la))
	  return;

     /* Count the valid tics */
     for (nt = 0, i = la->first; i <= la->last; i++) {
	  l = AxisLabel(lw, i);
	  if ((l && *l && **l) || i == la->first || i == la->last)
	       ++nt;
     }

     /* Allocate tic values and labels */
     ac->num_tics = nt;
     ac->num_subtics = 0;
     ac->tic_values = (double *) XtMalloc(sizeof(double) * ac->num_tics);
     ac->subtic_values = NULL;
     ac->tic_label_string = (String *) XtMalloc(sizeof(String) * ac->num_tics);

     /* Set tic values and labels */
     for (ti = 0, i = la->first; i <= la->last && ti < nt; i++) {
	  l = AxisLabel(lw, i);
	  if ((l && *l && **l) || i == la->first || i == la->last) {
	       ac->tic_values[ti] = AxisXValue(lw, i);
	       if (l && *l && **l)
		    ac->tic_label_string[ti] = XtNewString(*l);
	       else
		    ac->tic_label_string[ti] = XtNewString("");
	       ++ti;
	  }
     }
}

/*
 *   The member routine
 */

void AtQuadLabelAxisAttachData(w, xdata, xtype, xstride, ldata, lstride, start, num)
Widget w;
XtPointer xdata;
AtDataType xtype;
String *ldata;
Cardinal xstride, lstride, start, num;
{
     AtQuadLabelAxisWidget lw = (AtQuadLabelAxisWidget) w;
     AtQuadLabelAxisPart *la = &lw->laxis;

     XtCheckSubclass((Widget)lw, atQuadLabelAxisWidgetClass,
		     "AtQuadLabelAxisAttachData needs an AtQuadLabelAxisWidget");

     la->xdata = xdata;
     la->xtype = xtype;
     la->xstride = xstride;
     la->ldata = ldata;
     la->lstride = lstride;
     la->start = start;
     la->num_items = num;
     la->first = la->last = 0;

     lw->axiscore.numbers_changed = True;
     AtPlotterRescaleRequired((Widget) lw);
}


/*  Creation function */

Widget AtCreateQuadLabelAxis(parent, name, arglist, argcount)
Widget parent;
char *name;
Arg *arglist;
Cardinal argcount;
{
     return (XtCreateWidget(name, atQuadLabelAxisWidgetClass, parent, arglist, argcount));
}
