/*
 *      XYBarPlotP.h
 *
 *      The AthenaTools Plotter Widget Set - Version 6.0
 *
 *      klin, Thu Sep  9 14:49:55 1993
 *
 *      SCCSid[] = "@(#) Plotter V6.0  93/09/09  XYBarPlotP.h"
 */

#ifndef _At_QuadBarPlotP_h
#define _At_QuadBarPlotP_h

#include "At.h"
#include "QuadPlotP.h"
#include "QuadBarPlot.h"

typedef struct {
    int empty;
} AtQuadBarPlotClassPart;

typedef struct _AtQuadBarPlotClassRec {
     ObjectClassPart          object_class;
     AtPlotClassPart          plot_class;
     AtQuadPlotClassPart        lplot_class;
     AtQuadBarPlotClassPart     bplot_class;
} AtQuadBarPlotClassRec;

extern AtQuadBarPlotClassRec atQuadBarPlotClassRec;

typedef struct {
     /* Resources */
     Boolean            do_outline;
     Boolean            do_fill;
     Pixel              outline_color;
     Pixel              fill_color;

     AtBarOrientation   bar_orientation;
     double             bar_offset;
     double             bar_width;
     AtPlotSide 	      err_bar_side;
     double							err_bar_size;

     /* Internal State */
     BoundingBox        saved_bb;  /* Needed so the zeroMin resource works */
     GC                 outline_gc;
     GC                 fill_gc;
} AtQuadBarPlotPart;

typedef struct _AtQuadBarPlotRec {
     ObjectPart         object;
     AtPlotPart         plot;
     AtQuadPlotPart       qplot;
     AtQuadBarPlotPart    bplot;
} AtQuadBarPlotRec;

typedef struct {
  short x, y, z, w, h;
} AtQuadPent;

#endif /* _At_QuadBarPlotP_h */
