/*
 *      XYBarPlot.h
 *
 *      The AthenaTools Plotter Widget Set - Version 6.0
 *
 *      klin, Tue Dec  7 15:54:42 1993
 *
 *      SCCSid[] = "@(#) Plotter V6.0  93/12/07  XYBarPlot.h"
 */


#ifndef _At_QuadBarPlot_h
#define _At_QuadBarPlot_h

#include "At.h"
#include "QuadPlot.h"
#include "AtConverters.h"
#include "Shading.h"


/* Additional resources to be set/fetched */

#define XtNbarOrientation	"barOrientation"
#define XtNbarOffset			"barOffset"
#define XtNbarWidth				"barWidth"
#define XtNdoOutline			"doOutline"
#define XtNdoFill					"doFill"
#define XtNoutlineColor		"outlineColor"
#define XtNfillColor			"fillColor"
#define XtNerrBarSide     "errBarSide"
#define XtNerrBarSize     "errBarSize"

#define XtCBarOrientation	"BarOrientation"
#define XtCBarOffset			"BarOffset"
#define XtCBarWidth				"BarWidth"
#define XtCDoOutline			"DoOutline"
#define XtCDoFill					"DoFill"
#define XtCErrBarSide     "ErrBarSide"
#define XtCErrBarSize     "ErrBarSize"

#define XtRBarOrientation	"BarOrientation"
#define XtRErrBarSide     "ErrBarSide"


/* Declare specific AtBarPlotWidget class and instance datatypes */

typedef struct _AtQuadBarPlotClassRec*    AtQuadBarPlotWidgetClass;
typedef struct _AtQuadBarPlotRec*         AtQuadBarPlotWidget;

/* Declare the class constant */

extern WidgetClass atQuadBarPlotWidgetClass;

#ifndef AtIsQuadBarPlot
#define AtIsQuadBarPlot(w) XtIsSubclass(w, atQuadBarPlotWidgetClass)
#endif

/* The bar orientations */

typedef enum {
     AtOrientVERTICAL,        /* vertical orientation, default */
     AtOrientHORIZONTAL,      /* horizontal orientation */
     AtOrientINVALID          /* invalid: use default */
} AtBarOrientation;


/* Creation function */

extern Widget AtCreateQuadBarPlot(Widget, char *, Arg *, Cardinal);


/* The member procedures. These ones are inherited from QuadPlot */

#define AtQuadBarPlotAttachData(w, xp,xt,xstride, yp,yt,ystride, \
			z1p,z1t,z1stride, z2p,z2t,z2stride, start,num) \
		AtQuadPlotAttachData((Widget) w, xp,xt,xstride, yp,yt,ystride, \
			z1p,z1t,z1stride, z2p,z2t,z2stride, start,num)
#define AtQuadBarPlotExtendData(w, n) \
     AtQuadPlotExtendData((Widget) w, n)

#define AtQuadBarPlotGetNumPoints(w) AtQuadGetNumPoints((Widget) w)


/* The member procedures for AtxxPoint data */

#define AtQuadBarPlotAttachDoublePoints(w, data, start, num) \
     AtQuadPlotAttachData((Widget) w, \
	  (XtPointer) &(data)->x, AtDouble, sizeof(AtDoublePoint), \
	  (XtPointer) &(data)->y, AtDouble, sizeof(AtDoublePoint), \
	  (XtPointer) &(data)->z1, AtDouble, sizeof(AtDoublePoint), \
	  (XtPointer) &(data)->z2, AtDouble, sizeof(AtDoublePoint), \
	  start, num)

#define AtQuadBarPlotAttachFloatPoints(w, data, start, num) \
     AtQuadPlotAttachData((Widget) w, \
	  (XtPointer) &(data)->x, AtFloat, sizeof(AtFloatPoint), \
	  (XtPointer) &(data)->y, AtFloat, sizeof(AtFloatPoint), \
	  (XtPointer) &(data)->z1, AtFloat, sizeof(AtFloatPoint), \
	  (XtPointer) &(data)->z2, AtFloat, sizeof(AtFloatPoint), \
	  start, num)

#define AtQuadBarPlotAttachIntPoints(w, data, start, num) \
     AtQuadPlotAttachData((Widget) w, \
	  (XtPointer) &(data)->x, AtInt, sizeof(AtIntPoint), \
	  (XtPointer) &(data)->y, AtInt, sizeof(AtIntPoint), \
	  (XtPointer) &(data)->z1, AtInt, sizeof(AtIntPoint), \
	  (XtPointer) &(data)->z2, AtInt, sizeof(AtIntPoint), \
	  start, num)

#define AtQuadBarPlotAttachShortPoints(w, data, start, num) \
     AtQuadPlotAttachData((Widget) w, \
	  (XtPointer) &(data)->x, AtShort, sizeof(AtShortPoint), \
	  (XtPointer) &(data)->y, AtShort, sizeof(AtShortPoint), \
	  (XtPointer) &(data)->z1, AtShort, sizeof(AtShortPoint), \
	  (XtPointer) &(data)->z2, AtShort, sizeof(AtShortPoint), \
	  start, num)

#endif /* _At_QuadBarPlot_h */
