/*
 *      XYBarPlot.c
 *
 *      The AthenaTools Plotter Widget Set - Version 6.0
 *
 *      klin, Thu Sep  9 14:49:55 1993
 *      klin, Sun Dec  5 19:56:29 1993, patchlevel 8
 *                                      Fast update and all stuff removed.
 *                                      Some changes in drawing for improving
 *                                      speed when extending data.
**
** 10.98 bjarthur
**  code seemed half written.  finished it off.
**  barOrientation, barOffset, barWidth all work well now.
**  xdata and zdata now both optional, as in QuadLinePlot
**
 */
static char SCCSid[] = "@(#) Plotter V6.0  93/12/05  XYBarPlot.c";


/*   AtQuadBarPlot widget. It is a subclass of the Quadplot derived from
 *   the BarPlot widget class..  */

#include "PlotterP.h"
#include "AxisCoreP.h"
#include "QuadBarPlotP.h"


/* Forward declare all the private widgetclass routines */

static void Draw(AtQuadBarPlotWidget, Display *, Drawable, Region, int);
static void DrawIcon(AtQuadBarPlotWidget, Display *, Drawable, int, int, int, int, Region);
static void Recalc(AtQuadBarPlotWidget, AtScale *, AtScale *, int, int);
static void ClassInit(void);
static void Initialize(AtQuadBarPlotWidget, AtQuadBarPlotWidget);
static void Destroy(AtQuadBarPlotWidget);
static Boolean SetValues(AtQuadBarPlotWidget, AtQuadBarPlotWidget, AtQuadBarPlotWidget);
static void Attach(AtQuadPlotWidget, BoundingBox *, int);
static Boolean AtCvtStringToBarOrientation(Display*, XrmValue*,
      Cardinal*, XrmValue*, XrmValue*, XtPointer*);
static Boolean AtCvtStringToErrBarSide(Display*, XrmValue*,
      Cardinal*, XrmValue*, XrmValue*, XtPointer*);


/* The resources */

static double dflt_offset = 0.0;
static double dflt_width = 1.0;
static double dflt_err_bar_size = 0.5;

static void defFG( Widget w, int off, XrmValue *val)
{
  AtQuadBarPlotWidget pw = (AtQuadBarPlotWidget) w;

  val->addr = (XtPointer) & pw->plot.foreground;
}

#define off(field) XtOffsetOf(AtQuadBarPlotRec, bplot.field)
static XtResource resources[] = {
	{
    XtNdoOutline, XtCDoOutline,
    XtRBoolean, sizeof (Boolean),
    off(do_outline), XtRImmediate, (XtPointer) False
  },
  {
    XtNoutlineColor, XtCForeground,
    XtRPixel, sizeof (Pixel),
    off(outline_color), XtRCallProc, (XtPointer) defFG 
  },
  {
    XtNdoFill, XtCDoFill,
    XtRBoolean, sizeof (Boolean),
    off(do_fill), XtRImmediate, (XtPointer) True
  },
  {
    XtNfillColor, XtCForeground,
    XtRPixel, sizeof (Pixel),
    off(fill_color), XtRCallProc, (XtPointer) defFG 
  },
  {
    XtNbarOrientation, XtCBarOrientation,
    XtRBarOrientation, sizeof(AtBarOrientation),
    off(bar_orientation), XtRImmediate, (XtPointer) AtOrientVERTICAL
  },
  {
    XtNbarOffset, XtCBarOffset,
    XtRDouble, sizeof(double),
    off(bar_offset), XtRDouble, (XtPointer) &dflt_offset
  },
  {
    XtNbarWidth, XtCBarWidth,
    XtRDouble, sizeof(double),
    off(bar_width), XtRDouble, (XtPointer) &dflt_width
  },
  {
     XtNerrBarSide, XtCErrBarSide,
     XtRErrBarSide, sizeof(AtPlotSide),
     off(err_bar_side), XtRImmediate, (XtPointer) AtSideUPPER
  },
  {
    XtNerrBarSize, XtCErrBarSize,
    XtRDouble, sizeof(double),
    off(err_bar_size), XtRDouble, (XtPointer) &dflt_err_bar_size
  },
};
#undef off

AtQuadBarPlotClassRec atQuadBarPlotClassRec = {
  { /* core fields */
    /* superclass               */      (WidgetClass) &atQuadPlotClassRec,
    /* class_name               */      "AtQuadBarPlot",
    /* widget_size              */      sizeof(AtQuadBarPlotRec),
    /* class_initialize         */      (XtProc) ClassInit,
    /* class_part_initialize    */      NULL,
    /* class_inited             */      FALSE,
    /* initialize               */      (XtInitProc) Initialize,
    /* initialize_hook          */      NULL,
    /* pad                      */      NULL,
    /* pad                      */      NULL,
    /* pad                      */      0,
    /* resources                */      resources,
    /* num_resources            */      XtNumber(resources),
    /* xrm_class                */      NULLQUARK,
    /* pad                      */      FALSE,
    /* pad                      */      FALSE,
    /* pad                      */      FALSE,
    /* pad                      */      FALSE,
    /* destroy                  */      (XtWidgetProc) Destroy,
    /* pad                      */      NULL,
    /* pad                      */      NULL,
    /* set_values               */      (XtSetValuesFunc) SetValues,
    /* set_values_hook          */      NULL,
    /* pad                      */      NULL,
    /* get_values_hook          */      NULL,
    /* pad                      */      NULL,
    /* version                  */      XtVersion,
    /* callback_private         */      NULL,
    /* pad                      */      NULL,
    /* pad                      */      NULL,
    /* pad                      */      NULL,
    /* pad                      */      NULL
  },
  { /* atPlot fields */
    /* draw                     */      (AtPlotDrawProc) Draw,
    /* draw_icon                */      (AtPlotDrawIconProc) DrawIcon,
    /* recalc                   */      (AtPlotRecalcProc) Recalc
  },
  { /* atQuadPlot fields */
    /* attach_data              */      (AtQuadPlotAttachProc) Attach,
  },
  { /* atQuadBarPlot fields */
    /* empty                    */      0
  }
};

WidgetClass atQuadBarPlotWidgetClass = (WidgetClass)&atQuadBarPlotClassRec;


/* The core member procs */

static void ClassInit(void)
{
    XtSetTypeConverter(XtRString, XtRBarOrientation,
       AtCvtStringToBarOrientation, NULL, 0, XtCacheNone, NULL);
    XtSetTypeConverter(XtRString, XtRErrBarSide,
       AtCvtStringToErrBarSide, NULL, 0, XtCacheNone, NULL);
 
     *SCCSid = *SCCSid;       /* Keep gcc quiet */
}


/* Helper functions for GC management */

static void GetOutlineGC(AtQuadBarPlotWidget bw)
{
	XGCValues v;
	int mask = GCForeground;

	v.foreground = bw->bplot.outline_color;

	bw->bplot.outline_gc = XtGetGC(XtParent((Widget) bw), mask, &v);
}

static void FreeOutlineGC(AtQuadBarPlotWidget bw)
{
	XtReleaseGC(XtParent((Widget) bw), bw->bplot.outline_gc);
}

static void GetFillGC(AtQuadBarPlotWidget bw)
{
	XGCValues v;
	int mask = GCForeground | GCBackground | GCFillStyle;

	v.foreground = bw->bplot.fill_color;
	v.background = bw->plot.background;
	v.fill_style = FillSolid;

	bw->bplot.fill_gc = XtGetGC(XtParent((Widget) bw), mask, &v);
}

static void FreeFillGC(AtQuadBarPlotWidget bw)
{
	XtReleaseGC(XtParent((Widget) bw), bw->bplot.fill_gc);
}


static void Initialize(AtQuadBarPlotWidget req, AtQuadBarPlotWidget new)
{
	GetFillGC(new);
	GetOutlineGC(new);
}


static Boolean SetValues(AtQuadBarPlotWidget old, AtQuadBarPlotWidget req,
			AtQuadBarPlotWidget new)
{
#define Changed(fld) (old->bplot.fld != new->bplot.fld)
	Boolean recalc = False;
	Boolean redraw = False;

	if (Changed(do_fill) || Changed(do_outline)) {
		redraw = True;
	}

	if (Changed(fill_color)) {
		FreeFillGC(new);
		GetFillGC(new);
		redraw = True;
	}

	if (Changed(outline_color)) {
		FreeOutlineGC(new);
		GetOutlineGC(new);
		redraw = True;
	}

	if (Changed(bar_orientation) || Changed(bar_width) || Changed(bar_offset)) {
		recalc = True;
	}

	if (redraw)
		AtPlotterRedrawRequired((Widget) new);
	if (recalc)
		AtPlotterRecalcThisPlot((Widget) new);

	return False;
}
#undef Changed


static void Destroy(AtQuadBarPlotWidget bw)
{
	FreeFillGC(bw);
	FreeOutlineGC(bw);
	if (bw->qplot.pix)
		XtFree((char *) bw->qplot.pix);
}


/*  These routines are the ones called by the parent plot widget */

#define bp  (&((AtQuadBarPlotWidget)self)->bplot)
#define bpw ((AtQuadBarPlotWidget)self)
#define PIX ((AtQuadPent*) bpw->qplot.pix)
/* NB: PIX is not an lvalue (on some very picky compilers!!!) */


static void Attach(AtQuadPlotWidget self, BoundingBox *bb, int extending)
{
	Cardinal num;
	int i;
	double x, y, xn, yn, z1, z2;

  /* now calculate the bounding box */
  bb->xmax = bb->ymax = -HUGE_VAL;
  bb->xmin = bb->ymin = HUGE_VAL;
  for (i = 0; i < bpw->qplot.num_points; i++) {
    x = AtQuadPlotGetXValue(self, i);
    bb->xmax = Max(bb->xmax, x);
    bb->xmin = Min(bb->xmin, x);
    y = AtQuadPlotGetYValue(self, i);
    bb->ymax = Max(bb->ymax, y);
    bb->ymin = Min(bb->ymin, y);
		if((i==0) || ((i+1) == bpw->qplot.num_points))
  		switch(bp->bar_orientation) {
				case(AtOrientVERTICAL):
    			xn = AtQuadPlotGetXValue(self, (i==0) ? (i+1) : (i-1));
    			bb->xmax = Max(bb->xmax, x + 0.5*fabs(x-xn));
			    bb->xmin = Min(bb->xmin, x - 0.5*fabs(x-xn));
					break;
				case(AtOrientHORIZONTAL):
    			yn = AtQuadPlotGetYValue(self, (i==0) ? (i+1) : (i-1));
    			bb->ymax = Max(bb->ymax, y + 0.5*fabs(y-yn));
			    bb->ymin = Min(bb->ymin, y - 0.5*fabs(y-yn));
					break; }
					
    if(bpw->qplot.z1data != NULL) {
      z1 = AtQuadPlotGetZ1Value(self, i);
      z2 = (bpw->qplot.z2data == NULL) ? AtQuadPlotGetZ1Value(self, i) :
            AtQuadPlotGetZ2Value(self, i);
  		switch(bp->bar_orientation) {
				case(AtOrientVERTICAL):
		  		switch(bp->err_bar_side) {
						case(AtSideUPPER):
       	    	bb->ymax = Max(bb->ymax, y + z2);
							break;
						case(AtSideLOWER):
       	    	bb->ymin = Min(bb->ymin, y - z2);
							break;
						case(AtSideAWAY):
							if(y>0)
       	    		bb->ymax = Max(bb->ymax, y + z2);
							else
       	    		bb->ymin = Min(bb->ymin, y - z2);
							break;
						case(AtSideTOWARDS):
							if(y>0)
       	    		bb->ymin = Min(bb->ymin, y - z2);
							else
       	    		bb->ymax = Max(bb->ymax, y + z2);
							break; }
					break;
				case(AtOrientHORIZONTAL):
		  		switch(bp->err_bar_side) {
						case(AtSideUPPER):
   		      	bb->xmax = Max(bb->xmax, x + z2);
							break;
						case(AtSideLOWER):
   		      	bb->xmin = Min(bb->xmin, x - z2);
							break;
						case(AtSideAWAY):
							if(x>0)
   		      		bb->xmax = Max(bb->xmax, x + z2);
							else
   		      		bb->xmin = Min(bb->xmin, x - z2);
							break;
						case(AtSideTOWARDS):
							if(x>0)
   		      		bb->xmin = Min(bb->xmin, x - z2);
							else
   		      		bb->xmax = Max(bb->xmax, x + z2);
							break; }
					break; } } }

	/* Free old data if needed */
	if (!extending && bpw->qplot.release_when_attached) {
		if (bpw->qplot.pix)
			XtFree((char *) bpw->qplot.pix);
		bpw->qplot.num_alloc = 0;
		bpw->qplot.pix = NULL;
	}

	/* We have enough space for the data */
	if (bpw->qplot.num_alloc >= bpw->qplot.num_points)
		return;

	/* Calc number of data to allocate and allocate them */
	if (bpw->qplot.allocate_in_slices)
		num = 1 + (bpw->qplot.num_points | 0x7f);
	else
		num = bpw->qplot.num_points;
	if (num > bpw->qplot.num_alloc) {
		if (extending && bpw->qplot.num_alloc > 0) {
			bpw->qplot.pix = XtRealloc((char *) bpw->qplot.pix,
						num * sizeof(AtQuadPent));
			bp->saved_bb.xmax = Max(bp->saved_bb.xmax, bb->xmax);
			bp->saved_bb.ymax = Max(bp->saved_bb.ymax, bb->ymax);
			bp->saved_bb.xmin = Min(bp->saved_bb.xmin, bb->xmin);
			bp->saved_bb.ymin = Min(bp->saved_bb.ymin, bb->ymin);
		}
		else {
			bp->saved_bb = *bb;
			bpw->qplot.pix = XtMalloc(num * sizeof(AtQuadPent));
		}
		bpw->qplot.num_alloc = num;
	}
}

/* Draw the bar clipped by the given region.  */

static void Draw(AtQuadBarPlotWidget self, Display *dpy, Drawable drw,
			Region region, int refresh)
{
	AtPlotterWidget pw = (AtPlotterWidget) XtParent((Widget) self);
	AtPlotterLayout *pwl = &pw->plotter.layout;
	XRectangle linerectangle, fillrectangle;
	Region lineregion, fillregion;
	int i, start, end;
	double left,right;
	short x,y,w,h;

	if (bpw->qplot.num_calc < 1)	/* Nothing to draw */
		return;

	/* Get clip regions for outline and filled bar from the plotter layout */
	linerectangle.x = fillrectangle.x = pwl->x1 + 1;
	linerectangle.y = fillrectangle.y = pwl->y1 + 1;
	linerectangle.width = fillrectangle.width = pwl->width - 2;
	linerectangle.height = fillrectangle.height = pwl->height - 2;

	/* Now create and set the regions */
	lineregion = XCreateRegion();
	fillregion = XCreateRegion();
	XUnionRectWithRegion(&linerectangle, lineregion, lineregion);
	XUnionRectWithRegion(&fillrectangle, fillregion, fillregion);
	XSetRegion(dpy, bpw->plot.gc, lineregion);
	XSetRegion(dpy, bp->fill_gc, fillregion);

	if (refresh && !bpw->qplot.draw_all_when_extended) {
		start = bpw->qplot.draw_from;
		end = 1 + bpw->qplot.draw_to; }
	else {
		start = 0;
		end = bpw->qplot.num_calc; }

	for (i = start; i < end; i++) {
		if(bp->bar_orientation == AtOrientVERTICAL) {
			if(PIX[i].h >= 0) {
				y = PIX[i].y;
				h = PIX[i].h; }
			else {
				y = PIX[i].y + PIX[i].h;
				h = -PIX[i].h; }
			x = PIX[i].x;
			w = PIX[i].w; }
		if(bp->bar_orientation == AtOrientHORIZONTAL) {
			if(PIX[i].w >= 0) {
				x = PIX[i].x - PIX[i].w;
				w = PIX[i].w; }
			else {
				x = PIX[i].x;
				w = -PIX[i].w; }
			y = PIX[i].y;
			h = PIX[i].h; }

		if (bp->do_fill)
			XPS_FillRectangle(dpy, drw, bp->fill_gc, x, y, w, h);

		if (bp->do_outline) {
				XPS_DrawLine(dpy, drw, bp->outline_gc,
							x, y + h, x, y);
				XPS_DrawLine(dpy, drw, bp->outline_gc,
							x, y, x + w, y);
				XPS_DrawLine(dpy, drw, bp->outline_gc,
							x + w, y, x + w, y + h);
				XPS_DrawLine(dpy, drw, bp->outline_gc,
							x + w, y + h, x, y + h); } }

  if(bpw->qplot.z1data != NULL) {
		left = 0.5 - bp->err_bar_size / 2.0;
		right = 0.5 + bp->err_bar_size / 2.0;
		for (i = start; i < end; i++) {
  		switch(bp->bar_orientation) {
				case(AtOrientVERTICAL):
					XPS_DrawLine(dpy, drw, bp->do_outline ? bp->outline_gc : bp->fill_gc,
								(int)ceil(PIX[i].x + 0.5*PIX[i].w), PIX[i].y,
								(int)ceil(PIX[i].x + 0.5*PIX[i].w), PIX[i].z);
					XPS_DrawLine(dpy, drw, bp->do_outline ? bp->outline_gc : bp->fill_gc,
								(int)ceil(PIX[i].x + left*PIX[i].w), PIX[i].z,
								(int)ceil(PIX[i].x + right*PIX[i].w), PIX[i].z);
					break;
				case(AtOrientHORIZONTAL):
					XPS_DrawLine(dpy, drw, bp->do_outline ? bp->outline_gc : bp->fill_gc,
								PIX[i].x, (int)ceil(PIX[i].y + 0.5*PIX[i].h),
								PIX[i].z, (int)ceil(PIX[i].y + 0.5*PIX[i].h));
					XPS_DrawLine(dpy, drw, bp->do_outline ? bp->outline_gc : bp->fill_gc,
								PIX[i].z, (int)ceil(PIX[i].y + left*PIX[i].h),
								PIX[i].z, (int)ceil(PIX[i].y + right*PIX[i].h));
					break; } } }

	/* Unset and destroy the regions */
	XSetClipMask(dpy, bpw->plot.gc, None);
	XSetClipMask(dpy, bp->fill_gc, None);
	XDestroyRegion(lineregion);
	XDestroyRegion(fillregion);
}

/*  Draw the "icon" in the given place.  */

static void DrawIcon(AtQuadBarPlotWidget self, Display *dpy, Drawable drw,
			int x1, int y1, int width, int height, Region region)
{
     if (bp->do_fill) {
	  if (region)
	       XSetRegion(dpy, bp->fill_gc, region);
	  XFillRectangle(dpy, drw, bp->fill_gc, x1, y1, width, height);
	  if (region)
	       XSetClipMask(dpy, bp->fill_gc, None);
     }
}

/* Recalc the data according to the passed x and y scales */

static void Recalc(AtQuadBarPlotWidget self, AtScale *xs, AtScale *ys,
			int from, int to)
{
	int i;
	int xpix, ypix, zpix, wpix, hpix;
	double x, y, z1, xn, yn, x0, y0, w, h;

	if (from > to) {							/* Recalc all */
		from = 0;
		to = bpw->qplot.num_points - 1;
		bpw->qplot.draw_from = 0;
		bpw->qplot.draw_to = -1; }
	else {												/* Recalc partial */
		if (bpw->qplot.num_calc < from)
			from = bpw->qplot.num_calc;
		bpw->qplot.draw_from = from;
		bpw->qplot.draw_to = to; }
	bpw->qplot.num_calc = to + 1;

	/* Calc the bar width/height */
  switch(bp->bar_orientation) {
    case(AtOrientVERTICAL):
			if (AtScaleGetLow(ys) < 0 && AtScaleGetHigh(ys) > 0)
				y0 = 0.0;
			else if (AtScaleGetLow(ys) < 0)
				y0 = AtScaleGetHigh(ys);
			else
				y0 = AtScaleGetLow(ys);
			break;
    case(AtOrientHORIZONTAL):
			if (AtScaleGetLow(xs) < 0 && AtScaleGetHigh(xs) > 0)
				x0 = 0.0;
			else if (AtScaleGetLow(xs) < 0)
				x0 = AtScaleGetHigh(xs);
			else
				x0 = AtScaleGetLow(xs);
			break; }

	/* Calc and set the bars */
	for (i = from; i <= to; i++) {
		x = AtQuadPlotGetXValue((AtQuadPlotWidget) bpw, i);
		y = AtQuadPlotGetYValue((AtQuadPlotWidget) bpw, i);
  	switch(bp->bar_orientation) {
			case(AtOrientVERTICAL):
				xn = AtQuadPlotGetXValue((AtQuadPlotWidget) bpw, (i<to) ? i+1 : i-1);
				w = bp->bar_width*fabs(x-xn);
				x += (fabs(x-xn) * (bp->bar_offset-1.0) / 2.0);
				x += (fabs(x-xn) * (1.0-bp->bar_width) / 2.0);
				wpix = AtScaleUserToPixel(xs, x+w) - AtScaleUserToPixel(xs, x);
				xpix = AtScaleUserToPixel(xs, x);
				hpix = AtScaleUserToPixel(ys, y0) - AtScaleUserToPixel(ys, y);
				ypix = AtScaleUserToPixel(ys, y);
    		if(bpw->qplot.z1data != NULL) {
		  		z1 = AtQuadPlotGetZ1Value((AtQuadPlotWidget) bpw, i);
  				switch(bp->err_bar_side) {
						case(AtSideUPPER):
							zpix = AtScaleUserToPixel(ys, y + z1);
							break;
						case(AtSideLOWER):
							zpix = AtScaleUserToPixel(ys, y - z1);
							break;
						case(AtSideAWAY):
							zpix = AtScaleUserToPixel(ys, y + ((y>0) ? z1 : -z1));
							break;
						case(AtSideTOWARDS):
							zpix = AtScaleUserToPixel(ys, y + ((y>0) ? -z1 : z1));
							break; } }
				break;
			case(AtOrientHORIZONTAL):
				yn = AtQuadPlotGetYValue((AtQuadPlotWidget) bpw, (i<to) ? i+1 : i-1);
				h = bp->bar_width*fabs(y-yn);
				y -= (fabs(y-yn) * (bp->bar_offset-1.0) / 2.0);
				y -= (fabs(y-yn) * (1.0-bp->bar_width) / 2.0);
				hpix = AtScaleUserToPixel(ys, y-h) - AtScaleUserToPixel(ys, y);
				ypix = AtScaleUserToPixel(ys, y);
				wpix = AtScaleUserToPixel(xs, x) - AtScaleUserToPixel(xs, x0);
				xpix = AtScaleUserToPixel(xs, x);
    		if(bpw->qplot.z1data != NULL) {
		  		z1 = AtQuadPlotGetZ1Value((AtQuadPlotWidget) bpw, i);
  				switch(bp->err_bar_side) {
						case(AtSideUPPER):
							zpix = AtScaleUserToPixel(xs, x + z1);
							break;
						case(AtSideLOWER):
							zpix = AtScaleUserToPixel(xs, x - z1);
							break;
						case(AtSideAWAY):
							zpix = AtScaleUserToPixel(xs, x + ((x>0) ? z1 : -z1));
							break;
						case(AtSideTOWARDS):
							zpix = AtScaleUserToPixel(xs, x + ((x>0) ? -z1 : z1));
							break; } }
				break; }
		PIX[i].x = xpix;
		PIX[i].y = ypix;
		PIX[i].z = zpix;
		PIX[i].w = wpix;
		PIX[i].h = hpix; }
}

/*  Resource converters */

typedef struct {
  char *string;
  int val;
} AtGenericRec;

static AtGenericRec orient_table[] = {
     { "VERTICAL",   (int)AtOrientVERTICAL   },
     { "HORIZONTAL", (int)AtOrientHORIZONTAL },
     { NULL,         -1                 } };

static AtGenericRec bar_side_table[] =
{
      {"UPPER", (int) AtSideUPPER},
      {"LOWER", (int) AtSideLOWER},
      {"AWAY", (int) AtSideAWAY},
      {"TOWARDS", (int) AtSideTOWARDS},
      {"BOTH", (int) AtSideBOTH},
      {NULL, -1}
};

static int parse_generic(char *var, AtGenericRec *table)
{
  int i;

  i=0;
  while(table[i].string!=NULL) {
    if(!strcasecmp(table[i].string,var))
      return(table[i].val);
    i++; }

  return(-1);
}

static Boolean AtCvtStringToBarOrientation(Display *dpy, XrmValue *args,
      Cardinal *num_args, XrmValue *from, XrmValue *to,
      XtPointer *converter_data)
{
  static AtBarOrientation orient;

  assert(to->addr == NULL);

  orient = parse_generic(from->addr, orient_table);

  if (orient == -1)
    XtDisplayStringConversionWarning(dpy, from->addr, XtRBarOrientation);
  else {
    to->addr = (caddr_t) &orient;
    to->size = sizeof(AtBarOrientation); }

  return(True);
}

static Boolean AtCvtStringToErrBarSide(Display * dpy, XrmValue * args,
      Cardinal * num_args, XrmValue * from, XrmValue * to,
      XtPointer * converter_data)
{
  static AtPlotSide bar_side;

  assert(to->addr == NULL);

  bar_side = parse_generic(from->addr, bar_side_table);

  if (bar_side == -1)
    XtDisplayStringConversionWarning(dpy, from->addr, XtRErrBarSide);
  else {
    to->addr = (caddr_t) & bar_side;
    to->size = sizeof(AtPlotSide);
  }

  return (True);
}

/*  Creation function */

Widget AtCreateQuadBarPlot(Widget parent, char *name, Arg *arglist,
			Cardinal argcount)
{
     return (XtCreateWidget(name, atQuadBarPlotWidgetClass, parent, arglist, argcount));
}
