/*
 *      XYAxisP.h
 *
 *      The AthenaTools Plotter Widget Set - Version 6.0
 *
 *      klin, Tue Jul  7 13:59:47 1992
 *      klin, Sat Aug 15 10:31:50 1992, patchlevel 4
 *                                      Changed <At/..> to <X11/At/..>.
 *      klin, Fri Jul 23 17:41:23 1993, patchlevel 8
 *                                      New resources XtNticMultiplier,
 *                                      XtNautoSubtics and XtNnumSubtics.
 *                                      Some minor changes.
 *
 *      SCCSid[] = "@(#) Plotter V6.0  93/08/06  XYAxisP.h"
 */

#ifndef _At_QuadAxisP_h
#define _At_QuadAxisP_h

#include "At.h"
#include "AxisCoreP.h"
#include "QuadAxis.h"

typedef struct {
     int empty;
} AtQuadAxisClassPart;

typedef struct _AtQuadAxisClassRec {
     ObjectClassPart     object_class;
     AtPlotClassPart     plot_class;
     AtAxisCoreClassPart axiscore;
     AtQuadAxisClassPart   axis_class;
} AtQuadAxisClassRec;

extern AtQuadAxisClassRec atQuadAxisClassRec;

typedef struct {
     /* Resources */
     AtTransform         axis_transform;
     Boolean             auto_tics;
     Boolean             auto_subtics;
     int                 num_subtics;
     double              tic_multiplier;
     String              lintic_format;
     String              logtic_format;
     /* Private state */
     Boolean             draw_origin;
     double              min;
     double              max;
     double              tmin;
     double              tmax;
     double              tic_interval;
     Cardinal            subtics_per_tic;
} AtQuadAxisPart;

typedef struct _AtQuadAxisRec {
     ObjectPart          object;
     AtPlotPart          plot;
     AtAxisCorePart      axiscore;
     AtQuadAxisPart        axis;
} AtQuadAxisRec;

#endif /* _At_QuadAxisP_h */
