/*
 *      XYAxis.h
 *
 *      The AthenaTools Plotter Widget Set - Version 6.0
 *
 *      klin, Tue Jul  7 13:59:47 1992
 *      klin, Sat Aug 15 10:31:50 1992, patchlevel 4
 *                                      Changed <At/..> to <X11/At/..>.
 *      klin, Fri Jul 23 17:41:23 1993, patchlevel 8
 *                                      New resources XtNticMultiplier,
 *                                      XtNautoSubtics and XtNnumSubtics.
 *                                      Some minor changes.
 *
 *      SCCSid[] = "@(#) Plotter V6.0  93/08/06  XYAxis.h.h"
 */


#ifndef _At_QuadAxis_h
#define _At_QuadAxis_h

#include "At.h"
#include "AxisCore.h"
#include "FontFamily.h"
#include "Text.h"
#include "Scale.h"

/* Declare specific AtQuadAxisWidget class and instance datatypes */

typedef struct _AtQuadAxisClassRec*  AtQuadAxisWidgetClass;
typedef struct _AtQuadAxisRec*       AtQuadAxisWidget;

/* Declare the class constant */

extern WidgetClass atQuadAxisWidgetClass;

#ifndef AtIsQuadAxis
#define AtIsQuadAxis(w)   XtIsSubclass(w, atQuadAxisWidgetClass)
#endif

/*
 * Resources available to be set/fetched
 */

#define XtNaxisTransform "axisTransform"
#define XtNautoTics "autoTics"
#define XtNautoSubtics "autoSubtics"
#define XtNnumSubtics "numSubtics"
#define XtNlinTicFormat "linTicFormat"
#define XtNlogTicFormat "logTicFormat"

#define XtCAxisTransform "AxisTransform"
#define XtCAutoTics "AutoTics"
#define XtCAutoSubtics "AutoSubtics"
#define XtCNumSubtics "NumSubtics"
#define XtCLinTicFormat "LinTicFormat"
#define XtCLogTicFormat "LogTicFormat"


/*  Creation function */

extern Widget AtCreateQuadAxis(Widget, char *, Arg *, Cardinal);

#endif /* _At_QuadAxis_h */
