/*
 *      PlotP.h
 *
 *      The AthenaTools Plotter Widget Set - Version 6.0
 *
 *      klin, Tue Jul  7 13:59:47 1992
 *      klin, Mon Jul 27 14:17:10 1992, patchlevel 2
 *                                      Draw() changed for drawing
 *                                      to a pixmap instead of a window.
 *      klin, Sat Aug 15 10:31:50 1992, patchlevel 4
 *                                      Changed <At/..> to <X11/At/..>.
 *      klin, Thu Aug  5 15:13:53 1993, patchlevel 8
 *                                      Control calculating of plot widgets.
 *                                      Some minor changes.
 *
 *      SCCSid[] = "@(#) Plotter V6.0  93/08/05  PlotP.h"
 */

#ifndef _At_PlotP_h
#define _At_PlotP_h


#include "At.h"
#include "Scale.h"
#include "Plotter.h"
#include "Plot.h"

#include <X11/ObjectP.h>

/*
 *   This widget serves as the base class for any plot type
 *   to be displayed in the AtPlotter widget.
 *   It is never intended to be instantiated itself.
 *   Only subclasses of it are.
 */

typedef void (*AtPlotDrawProc)(AtPlotWidget, Display *, Drawable, Region,
				  int);
typedef void (*AtPlotDrawIconProc)(AtPlotWidget, Display *, Drawable,
				      int, int, int, int, Region);
typedef void (*AtPlotRecalcProc)(AtPlotWidget, AtScale *, AtScale *,
				    int, int);
typedef struct _AtPlotClassPart {
     AtPlotDrawProc             draw;
     AtPlotDrawIconProc         draw_icon;
     AtPlotRecalcProc           recalc;
} AtPlotClassPart;

typedef struct _AtPlotClassRec {
     ObjectClassPart     object_class;
     AtPlotClassPart     plot_class;
} AtPlotClassRec;

extern AtPlotClassRec atPlotClassRec;

typedef struct _AtPlotPart {
     /* Resources */
     Pixel     foreground;
     Pixel     background;
     int       line_width;
     int       line_style;
     int       dash_length;
     Boolean   fast_update;
     /* Private state */
     GC        gc;
     Boolean   inlist;
} AtPlotPart;

typedef struct _AtPlotRec {
     ObjectPart     object;
     AtPlotPart     plot;
} AtPlotRec;

#define XtInheritDraw ((AtPlotDrawProc) _XtInherit)
#define XtInheritDrawIcon ((AtPlotDrawIconProc) _XtInherit)
#define XtInheritRecalc ((AtPlotRecalcProc) _XtInherit)

#endif /* _At_PlotP_h */
