/*
 *      Plot.h
 *
 *      The AthenaTools Plotter Widget Set - Version 6.0
 *
 *      klin, Tue Jul  7 13:59:47 1992
 *      klin, Mon Jul 27 14:16:59 1992, patchlevel 2
 *                                      Draw() changed for drawing
 *                                      to a pixmap instead of a window
 *      klin, Sat Aug 15 10:31:50 1992, patchlevel 4
 *                                      Changed <At/..> to <X11/At/..>.
 *      klin, Fri Jul 23 17:41:23 1993, patchlevel 8
 *                                      Some minor changes.
 *
 *      SCCSid[] = "@(#) Plotter V6.0  93/07/23  Plot.h"
 */


#ifndef _At_Plot_h
#define _At_Plot_h

#include "At.h"
#include "Scale.h"

#define XtNlineWidth "lineWidth"
#define XtNlineStyle "lineStyle"
#define XtNdashLength "dashLength"
#define XtNfastUpdate "fastUpdate"

#define XtCLineWidth "LineWidth"
#define XtCLineStyle "LineStyle"
#define XtCDashLength "DashLength"
#define XtCFastUpdate "FastUpdate"


/* declare specific AtPlotWidget class and instance datatypes */

typedef struct _AtPlotClassRec *AtPlotWidgetClass;
typedef struct _AtPlotRec *AtPlotWidget;


/* declare the class constant */

extern WidgetClass atPlotWidgetClass;

#ifndef AtIsPlot
#define AtIsPlot(w) XtIsSubclass(w, atPlotWidgetClass)
#endif

typedef enum {
	AtDouble,
	AtFloat,
	AtInt,
	AtShort
} AtDataType;


/*
 *   Extern routine for PostScript output.
 *   Write a line to the file to set the PostScript GC to reflect
 *   the plot instance record (linewidth, linestyle etc).
 *   Assume 1 PostScript unit is more-or-less one pixel.
 */

extern void AtPlotPSLineStyle(FILE *, Widget);


/* These are wrappers around the member functions */

extern void AtPlotDraw(Widget, Display *, Drawable, Region, int);
extern void AtPlotDrawIcon(Widget, Display *, Drawable, int, int, int, int, Region);
extern void AtPlotDrawPS(Widget, FILE *, AtScale *, AtScale *);
extern void AtPlotDrawIconPS(Widget, FILE *, int, int, int, int);
extern void AtPlotRecalc(Widget, AtScale *, AtScale *, int, int);

#endif /* _At_Plot_h */
