/*
 *      FontFamilyP.h
 *
 *      The AthenaTools Plotter Widget Set - Version 6.0
 *
 *      klin, Tue Jul  7 13:59:47 1992
 *      klin, Sat Aug 15 10:31:50 1992, patchlevel 4
 *                                      Typos fixed.
 *                                      Changed <At/..> to <X11/At/..>.
 *      klin, Fri Jul 23 17:41:23 1993, patchlevel 8
 *                                      AFMPATH changed to X default directory.
 *                                      Some minor changes.
 *
 *      SCCSid[] = "@(#) Plotter V6.0  93/07/23  FontFamilyP.h"
 */

#ifndef _At_FontFamilyP_h
#define _At_FontFamilyP_h

#include "At.h"
#include "FontFamily.h"

/* Font families */

#define AtFontCOURIER    0
#define AtFontHELVETICA  1
#define AtFontTIMES      2
#define AtFontSCHOOLBOOK 3
#define AtFontSYMBOL     4

typedef short PostscriptMetrics[256];

typedef struct {
    char                 *xname;
    char                 *psnames[4];
    int                  flags;
    char                 slantchar;
    PostscriptMetrics    *psmetrics;
    short                psascents[4];
    short                psdescents[4];
} AtFontFamilyInfo;

extern AtFontFamilyInfo _AtFontFamilies[];

#define XNAME(ff) (_AtFontFamilies[(ff)->num].xname)
#define FLAGS(ff) (_AtFontFamilies[(ff)->num].flags)
#define SLANTCHAR(ff) (_AtFontFamilies[(ff)->num].slantchar)
#define INFO(ff) (&_AtFontFamilies[(ff)->num])

#ifndef AFMPATH
#define AFMPATH "/usr/lib/X11/At/afm"
#endif

#endif /* _At_FontFamilyP_h */
