/*
 *      FontFamily.h
 *
 *      The AthenaTools Plotter Widget Set - Version 6.0
 *
 *      klin, Tue Jul  7 13:59:47 1992
 *      klin, Sun Aug  2 18:24:12 1992, patchlevel 3
 *                                      Define all font resources and
 *                                      classes
 *      klin, Sat Aug 15 10:31:50 1992, patchlevel 4
 *                                      Changed <At/..> to <X11/At/..>.
 *      klin, Fri Jul 23 17:41:23 1993, patchlevel 8
 *                                      Some minor changes.
 *
 *      SCCSid[] = "@(#) Plotter V6.0  93/07/23  FontFamily.h"
 */


#ifndef _At_FontFamily_h
#define _At_FontFamily_h

#include "At.h"

/* Resource names, classes and types for use with the X Toolkit */

#define XtNfontFamily "fontFamily"
#define XtNfontSize "fontSize"
#define XtNfontStyle "fontStyle"

#define XtCFontFamily "FontFamily"
#define XtCFontSize "FontSize"
#define XtCFontStyle "FontStyle"

#define XtRFontSize "FontSize"
#define XtRFontStyle "FontStyle"

/* Type faces */
#define AtFontPLAIN      0
#define AtFontBOLD       1    /* Set and clear these two bits to get */
#define AtFontITALIC     2    /*   the 4 possible typefaces */
#define AtFontBOLDITALIC 3

/* Point sizes */
#define AtFontSMALLEST   0
#define AtFontSMALL      1
#define AtFontMEDIUM     2
#define AtFontNORMAL     3
#define AtFontBIG        4
#define AtFontBIGGEST    5

typedef struct _AtFontFamily {
     Display *dpy;
     short refcount;
     int num;
     XFontStruct **cache;
     struct _AtFontFamily *next;
} AtFontFamily;

#define AtFontFamilyGetDisplay(family) ((family)->dpy)
#define AtFontBigger(size) ((size<AtFontBIGGEST) ? (size+1) : (size))
#define AtFontSmaller(size) ((size>AtFontSMALLEST) ? (size-1) : (size))
#define AtFontEmphasize(face) (face | AtFontBOLD)
#define AtFontDeemphasize(face) (face & ~AtFontBOLD)
#define AtFontItalicize(face) (face | AtFontITALIC)
#define AtFontDeitalicize(face) (face & ~AtFontITALIC)

extern AtFontFamily *AtFontFamilyGet(Display *, char *);
extern void AtFontFamilyRelease(AtFontFamily *);
extern XFontStruct *AtFontFetch(AtFontFamily *, int, int);
extern int AtFontPointSize(AtFontFamily *, int);
extern int AtFontPixelSize(AtFontFamily *, int);
extern int AtFontStringToSize(char *);
extern void AtRegisterFontSizeConverter(void);
extern void AtRegisterFontStyleConverter(void);
extern char *AtFontFamilyGetName(AtFontFamily *);
extern void AtFontSetStyle(AtFontFamily *, int);

#endif /* _At_FontFamily_h */
