/*
 *      AxisCoreP.h
 *
 *      The AthenaTools Plotter Widget Set - Version 6.0
 *
 *      klin, Tue Jul  7 13:59:47 1992
 *      klin, Mon Jul 27 14:16:10 1992, patchlevel 2
 *                                      Added new resource XtNnumberWidth
 *                                      and function AtAxisGetNumberWidth()
 *      klin, Sat Aug 15 10:31:50 1992, patchlevel 4
 *                                      Changed <At/..> to <X11/At/..>.
 *                                      Minor bug fix (G. Neumann)
 *      klin, Tue Nov 30 15:44:50 1993, patchlevel 8
 *                                      New resources XtNdrawAxis, XtNdrawTics,
 *                                      XtNgridColor, XtNaxisInOrigin,
 *                                      XtNnumbersInOrigin, XtNaxisMargin,
 *                                      XtNendpointPosition, XtNunit,
 *                                      XtNpreScale and XtNpreScaleMultiple
 *                                      with all needed stuff added.
 *                                      Some minor changes.
 *
 *      SCCSid[] = "@(#) Plotter V6.0  93/11/30  AxisCoreP.h"
 */

/*
 *   The core axis resources.
 *   This class is the superclass of all axis objects.
 *
 */

#ifndef _At_AxisCoreP_h
#define _At_AxisCoreP_h

#include "At.h"
#include "AxisCore.h"
#include "PlotP.h"

typedef void (*AtAxisRangeProc)(AtAxisCoreWidget, double *, double *,
				   double *, int *);
     typedef void (*AtAxisCalcProc)(AtAxisCoreWidget);

typedef struct {
     AtAxisRangeProc    range_proc;
     AtAxisCalcProc     calc_proc;
} AtAxisCoreClassPart;

#define XtInheritRangeProc ((AtAxisRangeProc)_XtInherit)
#define XtInheritCalcProc  ((AtAxisCalcProc)_XtInherit)

typedef struct _AtAxisCoreClassRec {
     ObjectClassPart     object_class;
     AtPlotClassPart     plot_class;
     AtAxisCoreClassPart axiscore_class;
} AtAxisCoreClassRec;

extern AtAxisCoreClassRec atAxisCoreClassRec;

typedef struct {
     /* Resources */
     double         min;
     double         max;
     double         tic_interval;
     Boolean        auto_scale;
     Boolean        round_endpoints;
     Boolean        vertical;
     Boolean        mirror;
     int            endpoint_position;
     Dimension      axis_margin;
     Boolean        pre_scale;
     int            pre_scale_multiple;
     /* The label */
     String         font_family;
     String         label;
     String         unit;
     int            label_size;
     int            label_style;
     Pixel          label_color;
     /* The Numbers */
     Dimension      default_number_width;
     int            number_size;
     int            number_style;
     Pixel          number_color;
     /* The callbacks */
     XtCallbackList range_callback;
     /* What-to-do resources */
     Boolean        axis_in_origin;
     Boolean        numbers_in_origin;
     Boolean        draw_label;
     Boolean        draw_axis;
     Boolean        draw_tics;
     Boolean        tics_inside;
     Boolean        tics_outside;
     Dimension      tic_length;
     Dimension      subtic_length;
     Boolean        draw_numbers;
     Boolean        numbers_outside;
     Boolean        draw_grid;
     Boolean        draw_subgrid;
     Boolean        draw_origin;
     Boolean        draw_frame;
     Dimension      axis_linewidth;
     Pixel          axis_color;
     Pixel          grid_color;

     /* Private state */
     AtScale        *scale;
     Dimension      x1, y1;
     Dimension      x2, y2;
     Dimension      grid_length;
     int            max_num_width;      /* As decided by callbacks etc */
     int            actual_num_width;   /* Computed as text generated */
     int            axis_width;         /* includes tics, label & numbers */
     AtFontFamily   *ff;
     GC             label_gc;
     AtText         *label_text;
     AtText         *unit_text;
     Dimension      label_line;         /* Start drawing the label at this pos */
     GC             axis_gc;
     XSegment       axis_segment;
     XSegment       origin_segment;
     XSegment       frame_segment;
     GC             tic_gc;
     XSegment       *tic_segments;      /* Is num_tics + num_subtics */
     GC             number_gc;
     double         *tic_values;        /* Axis coords of major tics */
     String         *tic_label_string;  /* Label to go with each */
     Cardinal       num_tics;           /* How many tics & labels */
     double         *subtic_values;     /* Axis coord of subtics */
     Cardinal       num_subtics;        /* How many IN TOTAL */
     Cardinal       num_ticsegments;
     Dimension      *tic_pos;           /* The position of each label */
     Dimension      *subtic_pos;        /* The position of subtic */
     Dimension      tic_label_line;     /* Is on this line somewhere */
     Dimension      origin_line;        /* Flag and position for origin */
     Dimension      numbers_line;       /* Flag and position for numbers */
     AtText         **tic_label_text;   /* And num_tics of these */
     GC             grid_gc;
     XSegment       *grid_segments;     /* Is num_tics of these */
     GC             subgrid_gc;
     XSegment       *subgrid_segments;  /* Is num_subtics of these */
     Boolean        numbers_changed;
     Boolean        position_changed;
} AtAxisCorePart;

typedef struct _AtAxisCoreRec {
     ObjectPart     object;
     AtPlotPart     plot;
     AtAxisCorePart axiscore;
} AtAxisCoreRec;

#endif /* _At_AxisCoreP_h */
