/*
 *      AxisCore.h
 *
 *      The AthenaTools Plotter Widget Set - Version 6.0
 *
 *      klin, Tue Jul  7 13:59:47 1992
 *      klin, Mon Jul 27 14:16:10 1992, patchlevel 2
 *                                      Added new resource XtNnumberWidth
 *                                      and function AtAxisGetNumberWidth()
 *      klin, Sat Aug 15 10:31:50 1992, patchlevel 4
 *                                      Changed <At/..> to <X11/At/..>.
 *      klin, Thu Jul 22 14:49:27 1993, patchlevel 8
 *                                      New resources XtNdrawAxis, XtNdrawTics
 *                                      and XtNgridColor added.
 *                                      Minor changes.
 *      klin, Tue Nov 30 15:47:50 1993, patchlevel 8
 *                                      New resources XtNdrawAxis, XtNdrawTics,
 *                                      XtNgridColor, XtNaxisInOrigin,
 *                                      XtNnumbersInOrigin, XtNaxisMargin,
 *                                      XtNendpointPosition, XtNunit,
 *                                      XtNpreScale and XtNpreScaleMultiple
 *                                      with all needed stuff added.
 *                                      New drawing proc AtAxisDraw().
 *                                      Some minor changes.
 *
 *      SCCSid[] = "@(#) Plotter V6.0  93/11/30  AxisCore.h"
 */


/*
 *   The AtAxisCore class is the parent placeholder for for all Axis
 *   classes.  It handles maintaing and calling the callback lists, and
 *   knows how to draw the axis and labels from the stuff stored in the
 *   private part of the record.  It has no recalc proceedure so
 *   actually setting up these arrays has to be done by subclasses.
 *
 *   The range and position functions can be chained from subclass range
 *   and position functions.
 */

#ifndef _At_AxisCore_h
#define _At_AxisCore_h

#include "At.h"
#include "AtConverters.h"
#include "Plot.h"
#include "FontFamily.h"
#include "Text.h"
#include "Scale.h"

/* declare specific AtAxisCoreWidget class and instance datatypes */

typedef struct _AtAxisCoreClassRec*     AtAxisCoreWidgetClass;
typedef struct _AtAxisCoreRec*          AtAxisCoreWidget;

/* declare the class constant */

extern WidgetClass  atAxisCoreWidgetClass;

#ifndef AtIsAxisCore
#define AtIsAxisCore(w)  XtIsSubclass(w, atAxisCoreWidgetClass)
#endif

/*
 *   Resources available to be set/fetched
 */

#define XtNmin "min"
#define XtNmax "max"
#define XtNticInterval "ticInterval"
#define XtNautoScale "autoScale"
#define XtNroundEndpoints "roundEndpoints"
#define XtNendpointPosition "endpointPosition"
#define XtNpreScale "preScale"
#define XtNpreScaleMultiple "preScaleMultiple"
#define XtNvertical "vertical"
#define XtNmirror "mirror"
#define XtNaxisMargin "axisMargin"
#define XtNrangeCallback "rangeCallback"
#define XtNdrawLabel "drawLabel"
#define XtNunit "unit"
#define XtNlabelSize "labelSize"
#define XtNlabelStyle "labelStyle"
#define XtNlabelColor "labelColor"
#define XtNnumberWidth "numberWidth"
#define XtNnumberSize "numberSize"
#define XtNnumberStyle "numberStyle"
#define XtNdrawAxis "drawAxis"
#define XtNnumberColor "numberColor"
#define XtNaxisInOrigin "axisInOrigin"
#define XtNnumbersInOrigin "numbersInOrigin"
#define XtNdrawTics "drawTics"
#define XtNticsInside "ticsInside"
#define XtNticsOutside "ticsOutside"
#define XtNticLength "ticLength"
#define XtNsubticLength "subticLength"
#define XtNdrawNumbers "drawNumbers"
#define XtNnumbersOutside "numbersOutside"
#define XtNdrawGrid "drawGrid"
#define XtNdrawSubgrid "drawSubgrid"
#define XtNdrawOrigin "drawOrigin"
#define XtNdrawFrame "drawFrame"
#define XtNaxisWidth "axisWidth"
#define XtNaxisColor "axisColor"
#define XtNgridColor "gridColor"
#define XtNticMultiplier "ticMultiplier"

#define XtCMin "Min"
#define XtCMax "Max"
#define XtCTicInterval "TicInterval"
#define XtCAutoScale "AutoScale"
#define XtCRoundEndpoints "RoundEndpoints"
#define XtCEndpointPosition "EndpointPosition"
#define XtCPreScale "PreScale"
#define XtCPreScaleMultiple "PreScaleMultiple"
#define XtCVertical "Vertical"
#define XtCMirror "Mirror"
#define XtCDrawLabel "DrawLabel"
#define XtCUnit "Unit"
#define XtCAxisMargin "AxisMargin"
#define XtCNumberWidth "NumberWidth"
#define XtCAxisInOrigin "AxisInOrigin"
#define XtCNumbersInOrigin "NumbersInOrigin"
#define XtCDrawAxis "DrawAxis"
#define XtCDrawTics "DrawTics"
#define XtCTicsInside "TicsInside"
#define XtCTicsOutside "TicsOutside"
#define XtCTicLength "TicLength"
#define XtCDrawNumbers "DrawNumbers"
#define XtCNumbersOutside "NumbersOutside"
#define XtCDrawGrid "DrawGrid"
#define XtCDrawSubgrid "DrawSubgrid"
#define XtCDrawOrigin "DrawOrigin"
#define XtCDrawFrame "DrawFrame"
#define XtCAxisWidth "AxisWidth"
#define XtCTicMultiplier "TicMultiplier"

/*
 *   These are the argument types for the callback lists:
 */

typedef struct {
     double     *minp, *maxp, *tic_intervalp;
     int        *max_widthp;
} AtAxisRangeArgs;


/*
 *   Call the member functions via this wrapper
 */

extern void AtAxisAskRange(Widget, double *, double *, int);

/*
 * Returns TRUE if size change requires tic_interval to be recalculated
 * via a call to AtAxisAskRange (again)
 */

extern Boolean AtAxisSetPosition(Widget, int, int, int, int, int);

/*
 *      Simple member functions
 */

extern AtScale *AtAxisGetScale(Widget);
extern int AtAxisWidth(Widget);
extern void AtAxisGetBounds(Widget, double *, double *);
extern AtTransform AtAxisGetTransform(Widget);
extern int AtAxisGetNumberWidth(Widget);
extern void AtAxisDraw(Widget, Display *, Drawable, Region);

#endif /* _At_AxisCore_h */
