% GL blend variable shape
% Requires peakfit.m, gaussian.m, andx lorentzian.m functions in the path.
disp('Three ways to fit shapes between Gaussian and Lorentzian')
x=0:.1:60;y=gaussian(x,30,10)+lorentzian(x,30,10)+.0*randn(size(x));
disp(' ')
disp('50% Gaussian/Lorentzian peak fit with Gaussian/Lorentzian blend model')
figure(1);
[FitResults,FitError]=peakfit([x;y],0,0,1,13,50)
subplot(2,1,1);
title('50% Gaussian/Lorentzian peak fit with Gaussian/Lorentzian blend model')
disp(' ')
disp('50% Gaussian/Lorentzian peak fit with Voigt profile with specified alpha')
figure(2);
[FitResults,FitError]=peakfit([x;y],0,0,1,20,0.76067)
subplot(2,1,1);
title('Same peak fit with Voigt profile with specified alpha')
disp(' ')
disp('50% Gaussian/Lorentzian peak fit with Voigt profile with variable alpha')
figure(3);
[FitResults,FitError]=peakfit([x;y],0,0,1,30)
subplot(2,1,1);
title('Same peak fit with Voigt profile with variable alpha')
