function s=tsmooth2(Y,w)
%  tsmooth(Y,w) smooths vector Y by a triangular function of halfwidth w
%  T. C. O'Haver, 1988.
v=ones(1,w);
v=conv(v,v);
S=conv(Y,v);
startpoint=(length(v) + 1)/2;
endpoint=length(Y)+startpoint-1;
s=S(startpoint:endpoint) ./ sum(v);
L=length(Y);
s(1)=(Y(1)+Y(2))./2;
for k=2:startpoint-1,
    s(k)=mean(Y(1:(2*k-1)));
    s(L-k+1)=mean(Y(L-2*k+2:L));
end
s(L)=(Y(L)+Y(L-1))./2;