function fs=FrequencySpectrum(x,y)
% Returns the real part of the Fourier power spectrum of x,y as a matrix.
% Example: Frequency spectrum of noisy sine wave
% x=0:.01:2*pi;
% y=sin(200*x)+randn(size(x));
% fs=FrequencySpectrum(x,y);
% plot(fs(1,:),fs(2,:)) or plot(fs')
%
x=reshape(x,[1 length(x)]);
y=reshape(y,[1 length(x)]);
fy=fft(y);
sy=fy .* conj(fy);
plotrange=1:length(fy)/2;
realsy=real(sy(plotrange));
f=((plotrange-1)./range(x));
fs=([f;realsy]);

function r=range(x)
r=max(x)-min(x);
