function RedrawFourierFilter
% Re-computes amd plots the signal and the power 
% spectrum each time one of the sliders is changed.
% When the Sound slider is in the ON position (up), each time
% a slider is moved, the signal (y) is sent to the Windows WAVE
% audio device. When Sound is OFF (down), no sound is played when a 
% slider is moved. To change a signal type or add your own, simply
% change the definition of y in one of the case statements below.
% T. C. O'Haver (toh@umd.edu),  version 1.1, May, 2007

global x
global y
global samplingtime
global samplerate
global f1
global f2
global signaltype
global signalstring
global soundmode

x=[0:(1/samplerate):samplingtime];

% Computes signal for the selected signal type.
switch signaltype
    case 1
        signalstring='Sine wave of frequency F1 (Hz) and phase F2';
        y=sin(f1*2*pi.*(x+f2/100));
    case 2
        signalstring='Sine wave burst of frequency F1 (Hz) and length F2';
        y=sin(f1*2*pi.*x);
        m=round(length(y)/2);
        y(1:round(m-f2))=0;
        y(round(m+f2):length(y))=0;
    case 3
        signalstring='Square wave of frequency F1+F2/100 (Hz)';
        y=sign(sin((f1+f2/100)*2*pi.*x));  
    case 4
        signalstring='Sawtooth wave of frequency F1+F2/100 (Hz)';
        y=rem(x,max(x)/((f1+f2/100)*samplingtime));y=y/max(y);y=y-mean(y);
    case 5
        signalstring='440 Hz carrier amplitude modulated by sine wave of frequency F1 (Hz) and amplitude F2';
        y=(1+f2/100.*sin(2*f1*pi.*x)).*sin(880*pi.*x); 
    case 6
        signalstring='440 Hz carrier frequency modulated by sine wave of frequency F1 (Hz) and amplitude F2';
        y=sin(880*pi*x+f2/50.*sin(2*pi*f1*x)); 
    case 7
        signalstring='Sine wave of frequency F1 (Hz) modulated by Gaussian pulse of width F2';
        y=sin(2*f1*pi.*x).*gaussian(x,max(x)/2,f2*max(x)/100); 
    case 8
        signalstring='Random white noise';
        y=randn(size(x)); 
    case 9
        signalstring='Sine wave of frequency F1 (Hz) and amplitude F2 plus random white noise';
        y=f2/10*sin(f1*2*pi.*x)+randn(size(x));  
    case 10   
        signalstring='Sine wave sweep from 0 to f1 (Hz)';
        y=sin(x/max(x)*f1*2*pi.*(x));
end

% Plot the signal in the upper half of the window.
subplot(2,1,1)
plot(x,y)
title([ num2str(signalstring) ])
axis([0 samplingtime min(y) max(y) ])

% Plot the power spectrum  in the lower half of the window.
subplot(2,1,2)
fy=fft(y);
py=sqrt(fy .* conj(fy)); % Compute power spectrum
plotrange=1:length(fy)/2;
f=((plotrange-1)./range(x)); % Frequency axis for spectrum plot
bar(f,real(py(plotrange)),'r')
title('Power spectrum of signal (x = Hz)')
if soundmode==1,
    xlabel([ 'n= ' num2str(length(y)) '    Time = ' num2str(0.1*round(10*samplingtime)) '    Rate = ' num2str(round(samplerate)) '    F1 = ' num2str(0.1*round(10*f1))  '    F2= ' num2str(0.1*round(10*f2)) '   Sound ON'])
else
    xlabel([ 'n= ' num2str(length(y)) '    Time = ' num2str(0.1*round(10*samplingtime)) '    Rate = ' num2str(round(samplerate)) '    F1 = ' num2str(0.1*round(10*f1))  '    F2= ' num2str(0.1*round(10*f2)) '   Sound OFF'])
end
axis([min(f) max(f) 0 max(py)])

% Play the waveform through the sound output if the sounmode = 1
if soundmode==1,
    wavplay(y./2,samplerate);
end