% Digital signal generator (sumulator) with power spectrum
% display and sliders for "real time" control, useful for teaching and 
% demonstrating the power spectra of different types of signals and the 
% effect of signal duration and sampling rate. The signal slider selects  
% from 10 different signals (you can change these in RedrawSpectrum.m).
% The Time slider controls the total duration of signal, the Rate  
% slider controls the sample rate, and the F1 and F2 sliders control
% the global variables f1 and f2 which are used in different ways in 
% the different signals.  The Sound slider has only two settings:
% OFF (down) and ON (up).  When Sound is ON, each time a slider is moved,
% the signal (y) is sent to the Windows WAVE audio device. When Sound
% is OFF, no sound is played whena slider is moved. However, even
% when Sound is OFF, clicking on the Sound slider plays the signal 
% once for each click.
% T. C. O'Haver (toh@umd.edu),  version 1.1, May, 2007
clear
global x
global y
global samplingtime
global samplerate
global f1
global f2
global signaltype
global signalstring
global soundmode
close

% Initial values of parameters
samplingtime=.1;  % Total duration of sampled signal, in sec, millisec, or microsec.
samplerate=8000; % Sample rate in Hz, KHz, or MHz, respectively.
f1=250;
f2=12;
signaltype=1;  % Sine wave initially
soundmode=0; % Sound off initially

% Plot the signal and its power spectrum
RedrawSpectrum;
h=figure(1);
h2=gca;
  
% Maximum ranges of the sliders (change as needed)
MaxSamplingtime=1;
MaxSampleRate=10000;
MaxF1=5000;
MaxF2=100;

% Draw the sliders
rtslid(h,@SignalSlider,h2,1,'Scale',[1 10],'Def',1,'Back',[0.9 0.9 0.9],'Label','Signal','Position',[0.02 0.8 0.03 0.12]);
rtslid(h,@SamplingtimeSlider,h2,0,'Scale',[.1 MaxSamplingtime],'Def',samplingtime,'Back',[0.9 0.9 0.9],'Label','Time','Position',[0.02 0.4 0.03 0.3]);
rtslid(h,@SampleRateSlider,h2,0,'Scale',[1 MaxSampleRate],'Def',samplerate,'Back',[0.9 0.9 0.9],'Label','Rate','Position',[0.02 0.02 0.03 0.3]);
rtslid(h,@f1Slider,h2,0,'Scale',[.7 log10(MaxF1)],'Def',log10(f1),'Back',[0.9 0.9 0.9],'Label','F1','Position',[0.95 0.6 0.03 0.35]);
rtslid(h,@f2Slider,h2,0,'Scale',[1 MaxF2],'Def',f2,'Back',[0.9 0.9 0.9],'Label','F2','Position',[0.95 0.15 0.03 0.35]);
rtslid(h,@SoundButton,h2,0,'Scale',[0 1],'Def',0,'Back',[0.9 0.9 0.9],'Label','Sound','Position',[0.95 0.02 0.03 0.04]);
