% Self-running demonstration of a diffraction grating spectrum
% by addition of sinewaves from the superimposition of 
% reflections from multiple grooves, with phase shift due to incremental 
% path length difference between waves from the adjacent grooves.
% Shows build-up of resultant diffraction pattern as superimposed waves 
% are added.  Note: For a clearer presentation, drag the figure1 
% and figure2 windows so they do not overlap. 
% Tom O'Haver, toh@umd.edu, March 2006
clear
% N = Number of grooves in grating (Try 2 to 30): 
N=100;
% Suggestion: start out with N=2; the "spectrum" is just a sine 
% wave in that case, the ultimate in low resolution!). Then try N=3, 4,
% 5...  what happens as N increases.  Real gratings have N = 1000's
format compact
clf
hold off
start=cputime;
x=[0:.1:pi];  % x-axis for one cycle of sine wave (wavelength=2)
z=zeros(size(x));
StartPLD=5;
EndPLD=14;
Increment=.05;
intensity=zeros(1,2000);
OPL=zeros(1,2000);
k=1;
figure(1);clf
axis([-.5 3.5 -1 1]);
figure(2);clf
axis([0 2.5 0 20*N*N]);
ylabel('Relative irradiance')
xlabel('Pathlength difference between adjacent grooves, in wavelengths')
title('Observed irradiance  (Mean-square of sum of all reflections)')
for pld=StartPLD:Increment:EndPLD,  % path length difference in radians
  z=zeros(size(x));
  a=0;
  figure(1);clf; hold on
  xlabel('Path length difference shown is close to one wavelength (first order)')
  ylabel('electric vector magnitude')
  title('Electric vectors of the separate waves from each groove')
  text(1,.9,['Grating has ' num2str(N) ' grooves'])
  for j=1:N, 
     y=sin(3.*x+a);
     z=z+y;   % z is waveform (sine) resulting from superimposition
     figure(1);axis([0 3 -1 1]);plot(x,y)
     a=a+pld;
  end
  hold off
  drawnow
  intensity(k)=sum(z.*z);  % calculates mean amplitude
  OPL(k)=pld./(2*pi);
  figure(2); hold on; plot(OPL(1:k-1),intensity(1:k-1))
  drawnow
  k=k+1;
end
hold off
figure(2)
ElapsedTime=cputime-start